/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spark.util.PrestoSparkFailureUtils;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;

public class PrestoSparkDataDefinitionExecution<T extends Statement>
implements IPrestoSparkQueryExecution {
    private static final Logger log = Logger.get(PrestoSparkDataDefinitionExecution.class);
    private final DDLDefinitionTask<T> task;
    private final T statement;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final Session session;
    private final QueryStateTimer queryStateTimer;
    private final WarningCollector warningCollector;

    public PrestoSparkDataDefinitionExecution(DDLDefinitionTask<T> task, T statement, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, Session session, QueryStateTimer queryStateTimer, WarningCollector warningCollector) {
        this.task = Objects.requireNonNull(task, "task is null");
        this.statement = (Statement)Objects.requireNonNull(statement, "statement is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.queryStateTimer = Objects.requireNonNull(queryStateTimer, "queryStateTimer is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public List<List<Object>> execute() {
        this.queryStateTimer.beginRunning();
        try {
            ListenableFuture future = this.task.execute(this.statement, this.transactionManager, this.metadata, this.accessControl, this.session, Collections.emptyList(), this.warningCollector);
            MoreFutures.getFutureValue((Future)future);
            this.queryStateTimer.beginFinishing();
            PrestoSparkDataDefinitionExecution.commit(this.session, this.transactionManager);
            this.queryStateTimer.endQuery();
        }
        catch (Throwable executionException) {
            this.queryStateTimer.beginFinishing();
            try {
                PrestoSparkDataDefinitionExecution.rollback(this.session, this.transactionManager);
            }
            catch (RuntimeException rollbackFailure) {
                log.error((Throwable)rollbackFailure, "Encountered error when performing rollback");
            }
            Optional<ExecutionFailureInfo> failureInfo = Optional.of(Failures.toFailure((Throwable)executionException));
            this.queryStateTimer.endQuery();
            throw PrestoSparkFailureUtils.toPrestoSparkFailure(this.session, failureInfo.get());
        }
        return Collections.emptyList();
    }

    private static void commit(Session session, TransactionManager transactionManager) {
        MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(PrestoSparkDataDefinitionExecution.getTransactionInfo(session, transactionManager).getTransactionId()));
    }

    private static void rollback(Session session, TransactionManager transactionManager) {
        MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(PrestoSparkDataDefinitionExecution.getTransactionInfo(session, transactionManager).getTransactionId()));
    }

    private static TransactionInfo getTransactionInfo(Session session, TransactionManager transactionManager) {
        Optional transaction = session.getTransactionId().flatMap(arg_0 -> ((TransactionManager)transactionManager).getOptionalTransactionInfo(arg_0));
        Preconditions.checkState((boolean)transaction.isPresent(), (Object)"transaction is not present");
        Preconditions.checkState((boolean)((TransactionInfo)transaction.get()).isAutoCommitContext(), (Object)"transaction doesn't have auto commit context enabled");
        return (TransactionInfo)transaction.get();
    }
}

