/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.google.common.base.Preconditions;

public class PhysicalResourceSettings {
    public static final PhysicalResourceSettings DISABLED_PHYSICAL_RESOURCE_SETTING = new PhysicalResourceSettings(0, 0, () -> {});
    private final int executorCount;
    private final int hashPartitionCount;

    public PhysicalResourceSettings(int executorCount, int hashPartitionCount) {
        this(executorCount, hashPartitionCount, () -> Preconditions.checkArgument((executorCount >= 0 && hashPartitionCount >= 0 ? 1 : 0) != 0, (Object)"executorCount and hashPartitionCount should be positive"));
    }

    public PhysicalResourceSettings(int executorCount, int hashPartitionCount, Runnable check) {
        check.run();
        this.executorCount = executorCount;
        this.hashPartitionCount = hashPartitionCount;
    }

    public int getHashPartitionCount() {
        return this.hashPartitionCount;
    }

    public int getExecutorCount() {
        return this.executorCount;
    }

    public boolean isEnabled() {
        return this.executorCount > 0 && this.hashPartitionCount > 0;
    }
}

