/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.presto.Session;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.classloader_interface.PrestoSparkFailure;
import com.facebook.presto.spark.classloader_interface.RetryExecutionStrategy;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class PrestoSparkFailureUtils {
    private PrestoSparkFailureUtils() {
    }

    public static PrestoSparkFailure toPrestoSparkFailure(Session session, ExecutionFailureInfo executionFailureInfo) {
        Objects.requireNonNull(executionFailureInfo, "executionFailureInfo is null");
        PrestoSparkFailure prestoSparkFailure = PrestoSparkFailureUtils.toPrestoSparkFailure(executionFailureInfo);
        Preconditions.checkState((prestoSparkFailure != null ? 1 : 0) != 0);
        Optional<RetryExecutionStrategy> retryExecutionStrategy = PrestoSparkFailureUtils.getRetryExecutionStrategy(session, executionFailureInfo.getErrorCode(), executionFailureInfo.getMessage());
        return new PrestoSparkFailure(prestoSparkFailure.getMessage(), prestoSparkFailure.getCause(), prestoSparkFailure.getType(), prestoSparkFailure.getErrorCode(), retryExecutionStrategy);
    }

    @Nullable
    private static PrestoSparkFailure toPrestoSparkFailure(ExecutionFailureInfo executionFailureInfo) {
        if (executionFailureInfo == null) {
            return null;
        }
        PrestoSparkFailure prestoSparkFailure = new PrestoSparkFailure(executionFailureInfo.getMessage(), (Throwable)PrestoSparkFailureUtils.toPrestoSparkFailure(executionFailureInfo.getCause()), executionFailureInfo.getType(), executionFailureInfo.getErrorCode() == null ? "" : executionFailureInfo.getErrorCode().getName(), Optional.empty());
        for (Object suppressed : executionFailureInfo.getSuppressed()) {
            prestoSparkFailure.addSuppressed((Throwable)Objects.requireNonNull(PrestoSparkFailureUtils.toPrestoSparkFailure((ExecutionFailureInfo)suppressed), "suppressed failure is null"));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : executionFailureInfo.getStack()) {
            stackTraceBuilder.add((Object)ExecutionFailureInfo.toStackTraceElement((String)stack));
        }
        ImmutableList stackTrace = stackTraceBuilder.build();
        prestoSparkFailure.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        return prestoSparkFailure;
    }

    private static Optional<RetryExecutionStrategy> getRetryExecutionStrategy(Session session, ErrorCode errorCode, String message) {
        if (errorCode == null || message == null) {
            return Optional.empty();
        }
        if (PrestoSparkSessionProperties.isRetryOnOutOfMemoryBroadcastJoinEnabled(session) && errorCode == StandardErrorCode.EXCEEDED_LOCAL_BROADCAST_JOIN_MEMORY_LIMIT.toErrorCode()) {
            return Optional.of(RetryExecutionStrategy.DISABLE_BROADCAST_JOIN);
        }
        return Optional.empty();
    }
}

