/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.spark.PrestoSparkConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public class PrestoSparkSessionProperties {
    public static final String SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED = "spark_partition_count_auto_tune_enabled";
    public static final String MIN_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE = "min_spark_input_partition_count_for_auto_tune";
    public static final String MAX_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE = "max_spark_input_partition_count_for_auto_tune";
    public static final String SPARK_INITIAL_PARTITION_COUNT = "spark_initial_partition_count";
    public static final String MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION = "max_splits_data_size_per_spark_partition";
    public static final String SHUFFLE_OUTPUT_TARGET_AVERAGE_ROW_SIZE = "shuffle_output_target_average_row_size";
    public static final String STORAGE_BASED_BROADCAST_JOIN_ENABLED = "storage_based_broadcast_join_enabled";
    public static final String STORAGE_BASED_BROADCAST_JOIN_WRITE_BUFFER_SIZE = "storage_based_broadcast_join_write_buffer_size";
    public static final String SPARK_BROADCAST_JOIN_MAX_MEMORY_OVERRIDE = "spark_broadcast_join_max_memory_override";
    public static final String SPARK_SPLIT_ASSIGNMENT_BATCH_SIZE = "spark_split_assignment_batch_size";
    public static final String SPARK_MEMORY_REVOKING_THRESHOLD = "spark_memory_revoking_threshold";
    public static final String SPARK_MEMORY_REVOKING_TARGET = "spark_memory_revoking_target";
    public static final String SPARK_RETRY_ON_OUT_OF_MEMORY_BROADCAST_JOIN_ENABLED = "spark_retry_on_out_of_memory_broadcast_join_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PrestoSparkSessionProperties(PrestoSparkConfig prestoSparkConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED, (String)"Automatic tuning of spark initial partition count based on splits size per partition", (Boolean)prestoSparkConfig.isSparkPartitionCountAutoTuneEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)MIN_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, (String)"Minimal Spark input partition count when Spark partition auto tune is enabled", (Integer)prestoSparkConfig.getMinSparkInputPartitionCountForAutoTune(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)MAX_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, (String)"Max Spark input partition count when Spark partition auto tune is enabled", (Integer)prestoSparkConfig.getMaxSparkInputPartitionCountForAutoTune(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPARK_INITIAL_PARTITION_COUNT, (String)"Initial partition count for Spark RDD when reading table", (Integer)prestoSparkConfig.getInitialSparkPartitionCount(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION, (String)"Maximal size in bytes for splits assigned to one partition", (DataSize)prestoSparkConfig.getMaxSplitsDataSizePerSparkPartition(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)SHUFFLE_OUTPUT_TARGET_AVERAGE_ROW_SIZE, (String)"Target average size for row entries produced by Presto on Spark for shuffle", (DataSize)prestoSparkConfig.getShuffleOutputTargetAverageRowSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)STORAGE_BASED_BROADCAST_JOIN_ENABLED, (String)"Use storage for distributing broadcast table", (Boolean)prestoSparkConfig.isStorageBasedBroadcastJoinEnabled(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)STORAGE_BASED_BROADCAST_JOIN_WRITE_BUFFER_SIZE, (String)"Maximum size in bytes to buffer before flushing pages to disk", (DataSize)prestoSparkConfig.getStorageBasedBroadcastJoinWriteBufferSize(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)SPARK_BROADCAST_JOIN_MAX_MEMORY_OVERRIDE, (String)"Maximum size of broadcast table in Presto on Spark", (DataSize)prestoSparkConfig.getSparkBroadcastJoinMaxMemoryOverride(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPARK_SPLIT_ASSIGNMENT_BATCH_SIZE, (String)"Number of splits are processed in a single iteration", (Integer)prestoSparkConfig.getSplitAssignmentBatchSize(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)SPARK_MEMORY_REVOKING_THRESHOLD, (String)"Revoke memory when memory pool is filled over threshold", (Double)prestoSparkConfig.getMemoryRevokingThreshold(), (boolean)false), (Object)PropertyMetadata.doubleProperty((String)SPARK_MEMORY_REVOKING_TARGET, (String)"When revoking memory, try to revoke so much that memory pool is filled below target at the end", (Double)prestoSparkConfig.getMemoryRevokingTarget(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.booleanProperty((String)SPARK_RETRY_ON_OUT_OF_MEMORY_BROADCAST_JOIN_ENABLED, (String)"Disable broadcast join on broadcast OOM and re-submit the query again within the same spark session", (Boolean)prestoSparkConfig.isRetryOnOutOfMemoryBroadcastJoinEnabled(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isSparkPartitionCountAutoTuneEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED, Boolean.class);
    }

    public static int getMinSparkInputPartitionCountForAutoTune(Session session) {
        return (Integer)session.getSystemProperty(MIN_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, Integer.class);
    }

    public static int getMaxSparkInputPartitionCountForAutoTune(Session session) {
        return (Integer)session.getSystemProperty(MAX_SPARK_INPUT_PARTITION_COUNT_FOR_AUTO_TUNE, Integer.class);
    }

    public static int getSparkInitialPartitionCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_INITIAL_PARTITION_COUNT, Integer.class);
    }

    public static DataSize getMaxSplitsDataSizePerSparkPartition(Session session) {
        return (DataSize)session.getSystemProperty(MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION, DataSize.class);
    }

    public static DataSize getShuffleOutputTargetAverageRowSize(Session session) {
        return (DataSize)session.getSystemProperty(SHUFFLE_OUTPUT_TARGET_AVERAGE_ROW_SIZE, DataSize.class);
    }

    public static boolean isStorageBasedBroadcastJoinEnabled(Session session) {
        return (Boolean)session.getSystemProperty(STORAGE_BASED_BROADCAST_JOIN_ENABLED, Boolean.class);
    }

    public static DataSize getStorageBasedBroadcastJoinWriteBufferSize(Session session) {
        return (DataSize)session.getSystemProperty(STORAGE_BASED_BROADCAST_JOIN_WRITE_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getSparkBroadcastJoinMaxMemoryOverride(Session session) {
        return (DataSize)session.getSystemProperty(SPARK_BROADCAST_JOIN_MAX_MEMORY_OVERRIDE, DataSize.class);
    }

    public static int getSplitAssignmentBatchSize(Session session) {
        return (Integer)session.getSystemProperty(SPARK_SPLIT_ASSIGNMENT_BATCH_SIZE, Integer.class);
    }

    public static double getMemoryRevokingThreshold(Session session) {
        return (Double)session.getSystemProperty(SPARK_MEMORY_REVOKING_THRESHOLD, Double.class);
    }

    public static double getMemoryRevokingTarget(Session session) {
        return (Double)session.getSystemProperty(SPARK_MEMORY_REVOKING_TARGET, Double.class);
    }

    public static boolean isRetryOnOutOfMemoryBroadcastJoinEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_RETRY_ON_OUT_OF_MEMORY_BROADCAST_JOIN_ENABLED, Boolean.class);
    }
}

