/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

public class PrestoSparkConfig {
    private boolean sparkPartitionCountAutoTuneEnabled = true;
    private int minSparkInputPartitionCountForAutoTune = 100;
    private int maxSparkInputPartitionCountForAutoTune = 1000;
    private int initialSparkPartitionCount = 16;
    private DataSize maxSplitsDataSizePerSparkPartition = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private DataSize shuffleOutputTargetAverageRowSize = new DataSize(1.0, DataSize.Unit.KILOBYTE);
    private boolean storageBasedBroadcastJoinEnabled;
    private DataSize storageBasedBroadcastJoinWriteBufferSize = new DataSize(24.0, DataSize.Unit.MEGABYTE);
    private String storageBasedBroadcastJoinStorage = "local";
    private DataSize sparkBroadcastJoinMaxMemoryOverride;
    private boolean smileSerializationEnabled = true;
    private int splitAssignmentBatchSize = 1000000;
    private double memoryRevokingThreshold;
    private double memoryRevokingTarget;
    private boolean retryOnOutOfMemoryBroadcastJoinEnabled;

    public boolean isSparkPartitionCountAutoTuneEnabled() {
        return this.sparkPartitionCountAutoTuneEnabled;
    }

    @Config(value="spark.partition-count-auto-tune-enabled")
    @ConfigDescription(value="Automatic tuning of spark partition count based on max splits data size per partition")
    public PrestoSparkConfig setSparkPartitionCountAutoTuneEnabled(boolean sparkPartitionCountAutoTuneEnabled) {
        this.sparkPartitionCountAutoTuneEnabled = sparkPartitionCountAutoTuneEnabled;
        return this;
    }

    @Config(value="spark.min-spark-input-partition-count-for-auto-tune")
    @ConfigDescription(value="Minimal Spark input partition count when Spark partition auto tune is enabled")
    public PrestoSparkConfig setMinSparkInputPartitionCountForAutoTune(int minSparkInputPartitionCountForAutoTune) {
        this.minSparkInputPartitionCountForAutoTune = minSparkInputPartitionCountForAutoTune;
        return this;
    }

    public int getMinSparkInputPartitionCountForAutoTune() {
        return this.minSparkInputPartitionCountForAutoTune;
    }

    @Config(value="spark.max-spark-input-partition-count-for-auto-tune")
    @ConfigDescription(value="Max Spark input partition count when Spark partition auto tune is enabled")
    public PrestoSparkConfig setMaxSparkInputPartitionCountForAutoTune(int maxSparkInputPartitionCountForAutoTune) {
        this.maxSparkInputPartitionCountForAutoTune = maxSparkInputPartitionCountForAutoTune;
        return this;
    }

    public int getMaxSparkInputPartitionCountForAutoTune() {
        return this.maxSparkInputPartitionCountForAutoTune;
    }

    public int getInitialSparkPartitionCount() {
        return this.initialSparkPartitionCount;
    }

    @Config(value="spark.initial-partition-count")
    @ConfigDescription(value="Initial partition count for Spark RDD when reading table")
    public PrestoSparkConfig setInitialSparkPartitionCount(int initialPartitionCount) {
        this.initialSparkPartitionCount = initialPartitionCount;
        return this;
    }

    public DataSize getMaxSplitsDataSizePerSparkPartition() {
        return this.maxSplitsDataSizePerSparkPartition;
    }

    @Config(value="spark.max-splits-data-size-per-partition")
    @ConfigDescription(value="Maximal size in bytes for splits assigned to one partition")
    public PrestoSparkConfig setMaxSplitsDataSizePerSparkPartition(DataSize maxSplitsDataSizePerSparkPartition) {
        this.maxSplitsDataSizePerSparkPartition = maxSplitsDataSizePerSparkPartition;
        return this;
    }

    @NotNull
    public DataSize getShuffleOutputTargetAverageRowSize() {
        return this.shuffleOutputTargetAverageRowSize;
    }

    @Config(value="spark.shuffle-output-target-average-row-size")
    @ConfigDescription(value="Target average size for row entries produced by Presto on Spark for shuffle")
    public PrestoSparkConfig setShuffleOutputTargetAverageRowSize(DataSize shuffleOutputTargetAverageRowSize) {
        this.shuffleOutputTargetAverageRowSize = shuffleOutputTargetAverageRowSize;
        return this;
    }

    public boolean isStorageBasedBroadcastJoinEnabled() {
        return this.storageBasedBroadcastJoinEnabled;
    }

    @Config(value="spark.storage-based-broadcast-join-enabled")
    @ConfigDescription(value="Distribute broadcast hashtable to workers using storage")
    public PrestoSparkConfig setStorageBasedBroadcastJoinEnabled(boolean storageBasedBroadcastJoinEnabled) {
        this.storageBasedBroadcastJoinEnabled = storageBasedBroadcastJoinEnabled;
        return this;
    }

    public DataSize getStorageBasedBroadcastJoinWriteBufferSize() {
        return this.storageBasedBroadcastJoinWriteBufferSize;
    }

    @Config(value="spark.storage-based-broadcast-join-write-buffer-size")
    @ConfigDescription(value="Maximum size in bytes to buffer before flushing pages to disk")
    public PrestoSparkConfig setStorageBasedBroadcastJoinWriteBufferSize(DataSize storageBasedBroadcastJoinWriteBufferSize) {
        this.storageBasedBroadcastJoinWriteBufferSize = storageBasedBroadcastJoinWriteBufferSize;
        return this;
    }

    public String getStorageBasedBroadcastJoinStorage() {
        return this.storageBasedBroadcastJoinStorage;
    }

    @Config(value="spark.storage-based-broadcast-join-storage")
    @ConfigDescription(value="TempStorage to use for dumping broadcast table")
    public PrestoSparkConfig setStorageBasedBroadcastJoinStorage(String storageBasedBroadcastJoinStorage) {
        this.storageBasedBroadcastJoinStorage = storageBasedBroadcastJoinStorage;
        return this;
    }

    public DataSize getSparkBroadcastJoinMaxMemoryOverride() {
        return this.sparkBroadcastJoinMaxMemoryOverride;
    }

    @Config(value="spark.broadcast-join-max-memory-override")
    public PrestoSparkConfig setSparkBroadcastJoinMaxMemoryOverride(DataSize sparkBroadcastJoinMaxMemoryOverride) {
        this.sparkBroadcastJoinMaxMemoryOverride = sparkBroadcastJoinMaxMemoryOverride;
        return this;
    }

    public boolean isSmileSerializationEnabled() {
        return this.smileSerializationEnabled;
    }

    @Config(value="spark.smile-serialization-enabled")
    public PrestoSparkConfig setSmileSerializationEnabled(boolean smileSerializationEnabled) {
        this.smileSerializationEnabled = smileSerializationEnabled;
        return this;
    }

    public int getSplitAssignmentBatchSize() {
        return this.splitAssignmentBatchSize;
    }

    @Config(value="spark.split-assignment-batch-size")
    public PrestoSparkConfig setSplitAssignmentBatchSize(int splitAssignmentBatchSize) {
        this.splitAssignmentBatchSize = splitAssignmentBatchSize;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingThreshold() {
        return this.memoryRevokingThreshold;
    }

    @Config(value="spark.memory-revoking-threshold")
    @ConfigDescription(value="Revoke memory when memory pool is filled over threshold")
    public PrestoSparkConfig setMemoryRevokingThreshold(double memoryRevokingThreshold) {
        this.memoryRevokingThreshold = memoryRevokingThreshold;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getMemoryRevokingTarget() {
        return this.memoryRevokingTarget;
    }

    @Config(value="spark.memory-revoking-target")
    @ConfigDescription(value="When revoking memory, try to revoke so much that memory pool is filled below target at the end")
    public PrestoSparkConfig setMemoryRevokingTarget(double memoryRevokingTarget) {
        this.memoryRevokingTarget = memoryRevokingTarget;
        return this;
    }

    public boolean isRetryOnOutOfMemoryBroadcastJoinEnabled() {
        return this.retryOnOutOfMemoryBroadcastJoinEnabled;
    }

    @Config(value="spark.retry-on-out-of-memory-broadcast-join-enabled")
    @ConfigDescription(value="Disable broadcast join on broadcast OOM and re-submit the query again within the same spark session")
    public PrestoSparkConfig setRetryOnOutOfMemoryBroadcastJoinEnabled(boolean retryOnOutOfMemoryBroadcastJoinEnabled) {
        this.retryOnOutOfMemoryBroadcastJoinEnabled = retryOnOutOfMemoryBroadcastJoinEnabled;
        return this;
    }
}

