/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.spark.execution.PrestoSparkOutputBuffer;
import com.facebook.presto.spark.execution.PrestoSparkRowBatch;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;

public class PrestoSparkRowOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final PrestoSparkOutputBuffer<PrestoSparkRowBatch> outputBuffer;
    private final Function<Page, Page> pagePreprocessor;
    private final PartitionFunction partitionFunction;
    private final List<Integer> partitionChannels;
    private final List<Optional<Block>> partitionConstants;
    private final boolean replicateNullsAndAny;
    private final OptionalInt nullChannel;
    private final int targetAverageRowSizeInBytes;
    private PrestoSparkRowBatch.PrestoSparkRowBatchBuilder rowBatchBuilder;
    private ListenableFuture<?> isBlocked = NOT_BLOCKED;
    private boolean finished;
    private boolean hasAnyRowBeenReplicated;

    public PrestoSparkRowOutputOperator(OperatorContext operatorContext, LocalMemoryContext systemMemoryContext, PrestoSparkOutputBuffer<PrestoSparkRowBatch> outputBuffer, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<Block>> partitionConstants, boolean replicateNullsAndAny, OptionalInt nullChannel, int targetAverageRowSizeInBytes) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
        this.partitionConstants = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionConstants, "partitionConstants is null"));
        this.replicateNullsAndAny = replicateNullsAndAny;
        this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
        this.targetAverageRowSizeInBytes = targetAverageRowSizeInBytes;
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public ListenableFuture<?> isBlocked() {
        if (this.isBlocked.isDone()) {
            this.isBlocked = this.outputBuffer.isFull();
            if (this.isBlocked.isDone()) {
                this.isBlocked = NOT_BLOCKED;
            }
        }
        return this.isBlocked;
    }

    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    public void addInput(Page page) {
        int positionCount = (page = this.pagePreprocessor.apply(page)).getPositionCount();
        if (positionCount == 0) {
            return;
        }
        int partitionCount = this.partitionFunction.getPartitionCount();
        if (this.rowBatchBuilder == null) {
            this.rowBatchBuilder = PrestoSparkRowBatch.builder(partitionCount, this.targetAverageRowSizeInBytes);
        }
        int channelCount = page.getChannelCount();
        Page partitionFunctionArguments = this.getPartitionFunctionArguments(page);
        for (int position = 0; position < positionCount; ++position) {
            boolean shouldReplicate;
            if (this.rowBatchBuilder.isFull()) {
                this.outputBuffer.enqueue(this.rowBatchBuilder.build());
                this.rowBatchBuilder = PrestoSparkRowBatch.builder(partitionCount, this.targetAverageRowSizeInBytes);
            }
            SliceOutput output = this.rowBatchBuilder.beginRowEntry();
            for (int channel = 0; channel < channelCount; ++channel) {
                Block block = page.getBlock(channel);
                block.writePositionTo(position, output);
            }
            boolean bl = shouldReplicate = this.replicateNullsAndAny && !this.hasAnyRowBeenReplicated || this.nullChannel.isPresent() && page.getBlock(this.nullChannel.getAsInt()).isNull(position);
            if (shouldReplicate) {
                this.hasAnyRowBeenReplicated = true;
                this.rowBatchBuilder.closeEntryForReplicatedRow();
                continue;
            }
            int partition = this.getPartition(partitionFunctionArguments, position);
            this.rowBatchBuilder.closeEntryForNonReplicatedRow(partition);
        }
        this.updateMemoryContext();
    }

    private int getPartition(Page partitionFunctionArgs, int position) {
        return this.partitionFunction.getPartition(partitionFunctionArgs, position);
    }

    private Page getPartitionFunctionArguments(Page page) {
        Block[] blocks = new Block[this.partitionChannels.size()];
        for (int i = 0; i < blocks.length; ++i) {
            Optional<Block> partitionConstant = this.partitionConstants.get(i);
            blocks[i] = partitionConstant.isPresent() ? new RunLengthEncodedBlock(partitionConstant.get(), page.getPositionCount()) : page.getBlock(this.partitionChannels.get(i).intValue());
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public Page getOutput() {
        return null;
    }

    public void finish() {
        if (this.rowBatchBuilder != null && !this.rowBatchBuilder.isEmpty()) {
            this.outputBuffer.enqueue(this.rowBatchBuilder.build());
            this.rowBatchBuilder = null;
        }
        this.updateMemoryContext();
        this.finished = true;
    }

    private void updateMemoryContext() {
        this.systemMemoryContext.setBytes(this.rowBatchBuilder == null ? 0L : this.rowBatchBuilder.getRetainedSizeInBytes());
    }

    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    public static class PrestoSparkRowOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PrestoSparkOutputBuffer<PrestoSparkRowBatch> outputBuffer;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<Block>> partitionConstants;
        private final boolean replicateNullsAndAny;
        private final OptionalInt nullChannel;
        private final int targetAverageRowSizeInBytes;

        public PrestoSparkRowOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, PrestoSparkOutputBuffer<PrestoSparkRowBatch> outputBuffer, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<Block>> partitionConstants, boolean replicateNullsAndAny, OptionalInt nullChannel, int targetAverageRowSizeInBytes) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicateNullsAndAny = replicateNullsAndAny;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
            this.targetAverageRowSizeInBytes = targetAverageRowSizeInBytes;
        }

        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PrestoSparkRowOutputOperator.class.getSimpleName());
            return new PrestoSparkRowOutputOperator(operatorContext, operatorContext.newLocalSystemMemoryContext(PrestoSparkRowOutputOperator.class.getSimpleName()), this.outputBuffer, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicateNullsAndAny, this.nullChannel, this.targetAverageRowSizeInBytes);
        }

        public void noMoreOperators() {
        }

        public OperatorFactory duplicate() {
            return new PrestoSparkRowOutputOperatorFactory(this.operatorId, this.planNodeId, this.outputBuffer, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicateNullsAndAny, this.nullChannel, this.targetAverageRowSizeInBytes);
        }
    }

    public static class PreDeterminedPartitionFunction
    implements PartitionFunction {
        private final int partitionId;
        private final int partitionCount;

        public PreDeterminedPartitionFunction(int partitionId, int partitionCount) {
            Preconditions.checkArgument((partitionId >= 0 && partitionId < partitionCount ? 1 : 0) != 0, (Object)"partitionId should be non-negative and less than partitionCount");
            this.partitionId = partitionId;
            this.partitionCount = partitionCount;
        }

        public int getPartitionCount() {
            return this.partitionCount;
        }

        public int getPartition(Page page, int position) {
            return this.partitionId;
        }
    }

    private static class ConstantPartitionFunction
    implements PartitionFunction {
        private ConstantPartitionFunction() {
        }

        public int getPartitionCount() {
            return 1;
        }

        public int getPartition(Page page, int position) {
            return 0;
        }
    }

    public static class PrestoSparkRowOutputFactory
    implements OutputFactory {
        private static final OutputPartitioning SINGLE_PARTITION = new OutputPartitioning((PartitionFunction)new ConstantPartitionFunction(), (List)ImmutableList.of(), (List)ImmutableList.of(), false, OptionalInt.empty());
        private final Optional<OutputPartitioning> preDeterminedPartition;
        private final PrestoSparkOutputBuffer<PrestoSparkRowBatch> outputBuffer;
        private final DataSize targetAverageRowSize;

        public PrestoSparkRowOutputFactory(PrestoSparkOutputBuffer<PrestoSparkRowBatch> outputBuffer, DataSize targetAverageRowSize, Optional<OutputPartitioning> preDeterminedPartition) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.targetAverageRowSize = Objects.requireNonNull(targetAverageRowSize, "targetAverageRowSize is null");
            this.preDeterminedPartition = Objects.requireNonNull(preDeterminedPartition, "preDeterminedPartition is null");
        }

        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, Optional<OutputPartitioning> outputPartitioning, PagesSerdeFactory serdeFactory) {
            OutputPartitioning partitioning = outputPartitioning.orElse(this.preDeterminedPartition.orElse(SINGLE_PARTITION));
            return new PrestoSparkRowOutputOperatorFactory(operatorId, planNodeId, this.outputBuffer, pagePreprocessor, partitioning.getPartitionFunction(), partitioning.getPartitionChannels(), (List)partitioning.getPartitionConstants().stream().map(constant -> constant.map(ConstantExpression::getValueBlock)).collect(ImmutableList.toImmutableList()), partitioning.isReplicateNullsAndAny(), partitioning.getNullChannel(), Math.toIntExact(this.targetAverageRowSize.toBytes()));
        }
    }
}

