/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.spark.PrestoSparkBroadcastDependency;
import com.facebook.presto.spark.PrestoSparkServiceWaitTimeMetrics;
import com.facebook.presto.spark.RddAndMore;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import scala.Tuple2;

public class PrestoSparkMemoryBasedBroadcastDependency
implements PrestoSparkBroadcastDependency<PrestoSparkSerializedPage> {
    private RddAndMore<PrestoSparkSerializedPage> broadcastDependency;
    private final DataSize maxBroadcastSize;
    private final long queryCompletionDeadline;
    private Broadcast<List<PrestoSparkSerializedPage>> broadcastVariable;
    private final Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics;

    public PrestoSparkMemoryBasedBroadcastDependency(RddAndMore<PrestoSparkSerializedPage> broadcastDependency, DataSize maxBroadcastSize, long queryCompletionDeadline, Set<PrestoSparkServiceWaitTimeMetrics> waitTimeMetrics) {
        this.broadcastDependency = Objects.requireNonNull(broadcastDependency, "broadcastDependency cannot be null");
        this.maxBroadcastSize = Objects.requireNonNull(maxBroadcastSize, "maxBroadcastSize cannot be null");
        this.queryCompletionDeadline = queryCompletionDeadline;
        this.waitTimeMetrics = Objects.requireNonNull(waitTimeMetrics, "waitTimeMetrics cannot be null");
    }

    @Override
    public Broadcast<List<PrestoSparkSerializedPage>> executeBroadcast(JavaSparkContext sparkContext) throws SparkException, TimeoutException {
        List broadcastValue = this.broadcastDependency.collectAndDestroyDependenciesWithTimeout(PrestoSparkUtils.computeNextTimeout(this.queryCompletionDeadline), TimeUnit.MILLISECONDS, this.waitTimeMetrics).stream().map(Tuple2::_2).collect(Collectors.toList());
        this.broadcastDependency = null;
        long compressedBroadcastSizeInBytes = broadcastValue.stream().mapToInt(page -> page.getBytes().length).sum();
        long uncompressedBroadcastSizeInBytes = broadcastValue.stream().mapToInt(page -> page.getUncompressedSizeInBytes()).sum();
        long maxBroadcastSizeInBytes = this.maxBroadcastSize.toBytes();
        if (compressedBroadcastSizeInBytes > maxBroadcastSizeInBytes) {
            throw ExceededMemoryLimitException.exceededLocalBroadcastMemoryLimit((DataSize)this.maxBroadcastSize, (String)String.format("Compressed broadcast size: %s", DataSize.succinctBytes((long)compressedBroadcastSizeInBytes)));
        }
        if (uncompressedBroadcastSizeInBytes > maxBroadcastSizeInBytes) {
            throw ExceededMemoryLimitException.exceededLocalBroadcastMemoryLimit((DataSize)this.maxBroadcastSize, (String)String.format("Uncompressed broadcast size: %s", DataSize.succinctBytes((long)uncompressedBroadcastSizeInBytes)));
        }
        this.broadcastVariable = sparkContext.broadcast(broadcastValue);
        return this.broadcastVariable;
    }

    @Override
    public void destroy() {
        if (this.broadcastVariable != null) {
            this.broadcastVariable.destroy();
        }
    }
}

