/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.Session;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spark.PrestoSparkSessionProperties;
import com.facebook.presto.spark.planner.PrestoSparkSplitAssigner;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.ToIntFunction;

public class PrestoSparkPartitionedSplitAssigner
implements PrestoSparkSplitAssigner {
    private final PlanNodeId tableScanNodeId;
    private final SplitSource splitSource;
    private final ToIntFunction<ConnectorSplit> splitBucketFunction;
    private final int maxBatchSize;
    private int sequenceId;

    public static PrestoSparkPartitionedSplitAssigner create(Session session, PlanNodeId tableScanNodeId, SplitSource splitSource, PartitioningHandle fragmentPartitioning, PartitioningProviderManager partitioningProviderManager) {
        return new PrestoSparkPartitionedSplitAssigner(tableScanNodeId, splitSource, PrestoSparkPartitionedSplitAssigner.getSplitBucketFunction(session, fragmentPartitioning, partitioningProviderManager), PrestoSparkSessionProperties.getSplitAssignmentBatchSize(session));
    }

    private static ToIntFunction<ConnectorSplit> getSplitBucketFunction(Session session, PartitioningHandle partitioning, PartitioningProviderManager partitioningProviderManager) {
        ConnectorNodePartitioningProvider partitioningProvider = PrestoSparkPartitionedSplitAssigner.getPartitioningProvider(partitioning, partitioningProviderManager);
        return partitioningProvider.getSplitBucketFunction((ConnectorTransactionHandle)partitioning.getTransactionHandle().orElse(null), session.toConnectorSession(), partitioning.getConnectorHandle());
    }

    private static ConnectorNodePartitioningProvider getPartitioningProvider(PartitioningHandle partitioning, PartitioningProviderManager partitioningProviderManager) {
        ConnectorId connectorId = (ConnectorId)partitioning.getConnectorId().orElseThrow(() -> new IllegalArgumentException("Unexpected partitioning: " + partitioning));
        return partitioningProviderManager.getPartitioningProvider(connectorId);
    }

    public PrestoSparkPartitionedSplitAssigner(PlanNodeId tableScanNodeId, SplitSource splitSource, ToIntFunction<ConnectorSplit> splitBucketFunction, int maxBatchSize) {
        this.tableScanNodeId = Objects.requireNonNull(tableScanNodeId, "tableScanNodeId is null");
        this.splitSource = Objects.requireNonNull(splitSource, "splitSource is null");
        this.splitBucketFunction = Objects.requireNonNull(splitBucketFunction, "splitBucketFunction is null");
        this.maxBatchSize = maxBatchSize;
        Preconditions.checkArgument((maxBatchSize > 0 ? 1 : 0) != 0, (Object)"maxBatchSize must be greater than zero");
    }

    @Override
    public Optional<SetMultimap<Integer, ScheduledSplit>> getNextBatch() {
        int remaining;
        if (this.splitSource.isFinished()) {
            return Optional.empty();
        }
        ArrayList<ScheduledSplit> scheduledSplits = new ArrayList<ScheduledSplit>();
        while ((remaining = this.maxBatchSize - scheduledSplits.size()) > 0) {
            SplitSource.SplitBatch splitBatch = (SplitSource.SplitBatch)MoreFutures.getFutureValue((Future)this.splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), Math.min(remaining, 1000)));
            for (Split split : splitBatch.getSplits()) {
                scheduledSplits.add(new ScheduledSplit((long)this.sequenceId++, this.tableScanNodeId, split));
            }
            if (!splitBatch.isLastBatch() && !this.splitSource.isFinished()) continue;
            break;
        }
        return Optional.of(this.assignSplitsToTasks(scheduledSplits));
    }

    private SetMultimap<Integer, ScheduledSplit> assignSplitsToTasks(List<ScheduledSplit> splits) {
        HashMultimap result = HashMultimap.create();
        for (ScheduledSplit scheduledSplit : splits) {
            int partitionId = this.splitBucketFunction.applyAsInt(scheduledSplit.getSplit().getConnectorSplit());
            result.put((Object)partitionId, (Object)scheduledSplit);
        }
        return result;
    }

    @Override
    public void close() {
        this.splitSource.close();
    }
}

