/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spi.page.PageCompressor;
import com.facebook.presto.spi.page.PageDecompressor;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.SerializedPage;
import com.github.luben.zstd.Zstd;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class PrestoSparkUtils {
    private static final int COMPRESSION_LEVEL = 3;

    private PrestoSparkUtils() {
    }

    public static PrestoSparkSerializedPage toPrestoSparkSerializedPage(SerializedPage serializedPage) {
        Slice slice = serializedPage.getSlice();
        Preconditions.checkArgument((boolean)slice.hasByteArray(), (Object)"slice is expected to be based on a byte array");
        return new PrestoSparkSerializedPage(BlockUtil.compactArray((byte[])slice.byteArray(), (int)slice.byteArrayOffset(), (int)slice.length()), serializedPage.getPositionCount(), serializedPage.getUncompressedSizeInBytes(), serializedPage.getPageCodecMarkers());
    }

    public static SerializedPage toSerializedPage(PrestoSparkSerializedPage prestoSparkSerializedPage) {
        return new SerializedPage(Slices.wrappedBuffer((byte[])prestoSparkSerializedPage.getBytes()), prestoSparkSerializedPage.getPageCodecMarkers(), Math.toIntExact(prestoSparkSerializedPage.getPositionCount()), prestoSparkSerializedPage.getUncompressedSizeInBytes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] bytes) {
        try (DeflaterInputStream decompressor = new DeflaterInputStream(new ByteArrayInputStream(bytes));){
            byte[] byArray = ByteStreams.toByteArray((InputStream)decompressor);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] decompress(byte[] bytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InflaterOutputStream compressor = new InflaterOutputStream(output);){
            compressor.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output.toByteArray();
    }

    public static PagesSerde createPagesSerde(BlockEncodingManager blockEncodingManager) {
        return new PagesSerde((BlockEncodingSerde)blockEncodingManager, Optional.of(PrestoSparkUtils.createPageCompressor()), Optional.of(PrestoSparkUtils.createPageDecompressor()), Optional.empty());
    }

    private static PageCompressor createPageCompressor() {
        return new PageCompressor(){

            public int maxCompressedLength(int uncompressedSize) {
                return Math.toIntExact(Zstd.compressBound((long)uncompressedSize));
            }

            public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                long size = Zstd.compressByteArray((byte[])output, (int)outputOffset, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength, (int)3);
                if (Zstd.isError((long)size)) {
                    throw new RuntimeException(Zstd.getErrorName((long)size));
                }
                return Math.toIntExact(size);
            }

            public void compress(ByteBuffer input, ByteBuffer output) {
                if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
                    throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
                }
                int inputOffset = input.arrayOffset() + input.position();
                int outputOffset = output.arrayOffset() + output.position();
                int written = this.compress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
                output.position(output.position() + written);
            }
        };
    }

    private static PageDecompressor createPageDecompressor() {
        return new PageDecompressor(){

            public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
                long size = Zstd.decompressByteArray((byte[])output, (int)0, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength);
                if (Zstd.isError((long)size)) {
                    String errorName = Zstd.getErrorName((long)size);
                    throw new RuntimeException("Zstd JNI decompressor failed with " + errorName);
                }
                return Math.toIntExact(size);
            }

            public void decompress(ByteBuffer input, ByteBuffer output) {
                if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
                    throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
                }
                int inputOffset = input.arrayOffset() + input.position();
                int outputOffset = output.arrayOffset() + output.position();
                int written = this.decompress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
                output.position(output.position() + written);
            }
        };
    }
}

