/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.Output;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.InputExtractor;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.OutputExtractor;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanOptimizers;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.util.StatementUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class PrestoSparkQueryPlanner {
    private final SqlParser sqlParser;
    private final PlanOptimizers optimizers;
    private final QueryExplainer queryExplainer;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final AccessControl accessControl;
    private final PlanChecker planChecker;

    @Inject
    public PrestoSparkQueryPlanner(SqlParser sqlParser, PlanOptimizers optimizers, QueryExplainer queryExplainer, Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, AccessControl accessControl, PlanChecker planChecker) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.optimizers = Objects.requireNonNull(optimizers, "optimizers is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
    }

    public PlanAndMore createQueryPlan(Session session, QueryPreparer.PreparedQuery preparedQuery, WarningCollector warningCollector) {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this.queryExplainer), preparedQuery.getParameters(), warningCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(false, session, this.optimizers.getPlanningTimeOptimizers(), idAllocator, this.metadata, this.sqlParser, this.statsCalculator, this.costCalculator, warningCollector, this.planChecker);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        Plan plan = logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
        List inputs = new InputExtractor(this.metadata, session).extractInputs(plan.getRoot());
        Optional output = new OutputExtractor().extractOutput(plan.getRoot());
        Optional queryType = StatementUtils.getQueryType(preparedQuery.getStatement().getClass());
        List columnNames = ((OutputNode)plan.getRoot()).getColumnNames();
        return new PlanAndMore(plan, Optional.ofNullable(analysis.getUpdateType()), columnNames, (Set<Input>)ImmutableSet.copyOf((Collection)inputs), output, queryType);
    }

    public static class PlanAndMore {
        private final Plan plan;
        private final Optional<String> updateType;
        private final List<String> fieldNames;
        private final Set<Input> inputs;
        private final Optional<Output> output;
        private final Optional<QueryType> queryType;

        public PlanAndMore(Plan plan, Optional<String> updateType, List<String> fieldNames, Set<Input> inputs, Optional<Output> output, Optional<QueryType> queryType) {
            this.plan = Objects.requireNonNull(plan, "plan is null");
            this.updateType = Objects.requireNonNull(updateType, "updateType is null");
            this.fieldNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(fieldNames, "fieldNames is null"));
            this.inputs = ImmutableSet.copyOf((Collection)Objects.requireNonNull(inputs, "inputs is null"));
            this.output = Objects.requireNonNull(output, "output is null");
            this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        }

        public Plan getPlan() {
            return this.plan;
        }

        public Optional<String> getUpdateType() {
            return this.updateType;
        }

        public List<String> getFieldNames() {
            return this.fieldNames;
        }

        public Set<Input> getInputs() {
            return this.inputs;
        }

        public Optional<Output> getOutput() {
            return this.output;
        }

        public Optional<QueryType> getQueryType() {
            return this.queryType;
        }
    }
}

