/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.spark.execution.PrestoSparkBufferedSerializedPage;
import com.facebook.presto.spark.execution.PrestoSparkOutputBuffer;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class PrestoSparkPageOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final PrestoSparkOutputBuffer<PrestoSparkBufferedSerializedPage> outputBuffer;
    private final Function<Page, Page> pagePreprocessor;
    private final PagesSerde pagesSerde;
    private boolean finished;

    public PrestoSparkPageOutputOperator(OperatorContext operatorContext, PrestoSparkOutputBuffer<PrestoSparkBufferedSerializedPage> outputBuffer, Function<Page, Page> pagePreprocessor, PagesSerde pagesSerde) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public ListenableFuture<?> isBlocked() {
        return this.outputBuffer.isFull();
    }

    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    public void addInput(Page page) {
        int positionCount = (page = this.pagePreprocessor.apply(page)).getPositionCount();
        if (positionCount == 0) {
            return;
        }
        List serializedPages = (List)PageSplitterUtil.splitPage((Page)page, (long)0x100000L).stream().map(arg_0 -> ((PagesSerde)this.pagesSerde).serialize(arg_0)).map(PrestoSparkBufferedSerializedPage::new).collect(ImmutableList.toImmutableList());
        serializedPages.forEach(this.outputBuffer::enqueue);
    }

    public Page getOutput() {
        return null;
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    public static class PrestoSparkOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PrestoSparkOutputBuffer<PrestoSparkBufferedSerializedPage> outputBuffer;
        private final Function<Page, Page> pagePreprocessor;
        private final BlockEncodingManager blockEncodingManager;

        public PrestoSparkOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, PrestoSparkOutputBuffer<PrestoSparkBufferedSerializedPage> outputBuffer, Function<Page, Page> pagePreprocessor, BlockEncodingManager blockEncodingManager) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        }

        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PrestoSparkPageOutputOperator.class.getSimpleName());
            return new PrestoSparkPageOutputOperator(operatorContext, this.outputBuffer, this.pagePreprocessor, PrestoSparkUtils.createPagesSerde(this.blockEncodingManager));
        }

        public void noMoreOperators() {
        }

        public OperatorFactory duplicate() {
            return new PrestoSparkOutputOperatorFactory(this.operatorId, this.planNodeId, this.outputBuffer, this.pagePreprocessor, this.blockEncodingManager);
        }
    }

    public static class PrestoSparkPageOutputFactory
    implements OutputFactory {
        private final PrestoSparkOutputBuffer<PrestoSparkBufferedSerializedPage> outputBuffer;
        private final BlockEncodingManager blockEncodingManager;

        public PrestoSparkPageOutputFactory(PrestoSparkOutputBuffer<PrestoSparkBufferedSerializedPage> outputBuffer, BlockEncodingManager blockEncodingManager) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        }

        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, Optional<OutputPartitioning> outputPartitioning, PagesSerdeFactory serdeFactory) {
            Preconditions.checkArgument((!outputPartitioning.isPresent() ? 1 : 0) != 0, (Object)"output partitioning is not expected to be present");
            return new PrestoSparkOutputOperatorFactory(operatorId, planNodeId, this.outputBuffer, pagePreprocessor, this.blockEncodingManager);
        }
    }
}

