/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;

public class PrestoSparkSettingsRequirements {
    public static final String SPARK_TASK_CPUS_PROPERTY = "spark.task.cpus";
    public static final String SPARK_EXECUTOR_CORES_PROPERTY = "spark.executor.cores";

    public void verify(SparkContext sparkContext, Session session) {
        PrestoSparkSettingsRequirements.verify(!SystemSessionProperties.isDistributedSortEnabled((Session)session), "distributed sort is not supported", new Object[0]);
        PrestoSparkSettingsRequirements.verify(SystemSessionProperties.getExchangeMaterializationStrategy((Session)session) == QueryManagerConfig.ExchangeMaterializationStrategy.NONE, "exchange materialization is not supported", new Object[0]);
        PrestoSparkSettingsRequirements.verify(SystemSessionProperties.getPartitioningProviderCatalog((Session)session).equals("system"), "partitioning provider other that system is not supported", new Object[0]);
        PrestoSparkSettingsRequirements.verify(!SystemSessionProperties.isRecoverableGroupedExecutionEnabled((Session)session) && !SystemSessionProperties.isGroupedExecutionEnabled((Session)session), "grouped execution is not supported", new Object[0]);
        PrestoSparkSettingsRequirements.verify(!SystemSessionProperties.isRedistributeWrites((Session)session), "redistribute writes is not supported", new Object[0]);
        PrestoSparkSettingsRequirements.verify(!SystemSessionProperties.isScaleWriters((Session)session), "scale writes is not supported", new Object[0]);
        PrestoSparkSettingsRequirements.verify(!SystemSessionProperties.isForceSingleNodeOutput((Session)session), "force single node output is expected to be disabled", new Object[0]);
        PrestoSparkSettingsRequirements.verifyExecutorConfiguration(sparkContext.conf());
    }

    private static void verifyExecutorConfiguration(SparkConf sparkConf) {
        String taskCpusString = sparkConf.get(SPARK_TASK_CPUS_PROPERTY, null);
        PrestoSparkSettingsRequirements.verify(taskCpusString != null, "%s must be set", SPARK_TASK_CPUS_PROPERTY);
        String executorCoresString = sparkConf.get(SPARK_EXECUTOR_CORES_PROPERTY, null);
        PrestoSparkSettingsRequirements.verify(executorCoresString != null, "%s must be set", SPARK_EXECUTOR_CORES_PROPERTY);
        int taskCpus = Integer.parseInt(taskCpusString);
        int executorCores = Integer.parseInt(executorCoresString);
        PrestoSparkSettingsRequirements.verify(taskCpus == executorCores, "%s (%s) must be equal to %s (%s)", SPARK_TASK_CPUS_PROPERTY, taskCpus, SPARK_EXECUTOR_CORES_PROPERTY, executorCores);
    }

    private static void verify(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format(message, args));
        }
    }

    public static void setDefaults(FeaturesConfig config) {
        config.setDistributedSortEnabled(false);
        config.setGroupedExecutionEnabled(false);
        config.setRecoverableGroupedExecutionEnabled(false);
        config.setColocatedJoinsEnabled(true);
        config.setRedistributeWrites(false);
        config.setScaleWriters(false);
        config.setPreferDistributedUnion(true);
        config.setForceSingleNodeOutput(false);
        config.setInlineSqlFunctions(true);
    }

    public static void setDefaults(QueryManagerConfig config) {
        config.setExchangeMaterializationStrategy(QueryManagerConfig.ExchangeMaterializationStrategy.NONE);
        config.setPartitioningProviderCatalog("system");
    }
}

