/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.execution.PrestoSparkPageInput;
import com.facebook.presto.spark.execution.PrestoSparkShuffleInput;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.util.CollectionAccumulator;
import scala.Tuple2;
import scala.collection.Iterator;

public class PrestoSparkShufflePageInput
implements PrestoSparkPageInput {
    private static final int TARGET_SIZE = 0x100000;
    private static final int BUFFER_SIZE = 0x133333;
    private static final int MAX_ROWS_PER_PAGE = 20000;
    private final List<Type> types;
    private final List<PrestoSparkShuffleInput> shuffleInputs;
    private final int taskId;
    private final CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector;
    @GuardedBy(value="this")
    private int currentIteratorIndex;
    @GuardedBy(value="this")
    private final ShuffleStats shuffleStats = new ShuffleStats();

    public PrestoSparkShufflePageInput(List<Type> types, List<PrestoSparkShuffleInput> shuffleInputs, int taskId, CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.shuffleInputs = ImmutableList.copyOf((Collection)Objects.requireNonNull(shuffleInputs, "shuffleInputs is null"));
        this.taskId = taskId;
        this.shuffleStatsCollector = Objects.requireNonNull(shuffleStatsCollector, "shuffleStatsCollector is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getNextPage() {
        DynamicSliceOutput output = new DynamicSliceOutput(this.types.isEmpty() ? 0 : 0x133333);
        int rowCount = 0;
        PrestoSparkShufflePageInput prestoSparkShufflePageInput = this;
        synchronized (prestoSparkShufflePageInput) {
            while (this.currentIteratorIndex < this.shuffleInputs.size()) {
                PrestoSparkShuffleInput input = this.shuffleInputs.get(this.currentIteratorIndex);
                Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>> iterator = input.getIterator();
                long currentIteratorProcessedBytes = 0L;
                long currentIteratorProcessedRows = 0L;
                long currentIteratorProcessedRowBatches = 0L;
                long start = System.currentTimeMillis();
                while (iterator.hasNext() && output.size() <= 0x100000 && rowCount <= 20000) {
                    ++currentIteratorProcessedRowBatches;
                    PrestoSparkMutableRow row = (PrestoSparkMutableRow)((Tuple2)iterator.next())._2;
                    if (row.getBuffer() != null) {
                        ByteBuffer buffer = row.getBuffer();
                        Verify.verify((buffer.remaining() >= 2 ? 1 : 0) != 0, (String)"row data is expected to be at least 2 bytes long", (Object[])new Object[0]);
                        currentIteratorProcessedBytes += (long)buffer.remaining();
                        short entryRowCount = PrestoSparkShufflePageInput.getShortLittleEndian(buffer);
                        rowCount += entryRowCount;
                        currentIteratorProcessedRows += (long)entryRowCount;
                        buffer.position(buffer.position() + 2);
                        output.writeBytes(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                        continue;
                    }
                    if (row.getArray() != null) {
                        Verify.verify((row.getLength() >= 2 ? 1 : 0) != 0, (String)"row data is expected to be at least 2 bytes long", (Object[])new Object[0]);
                        currentIteratorProcessedBytes += (long)row.getLength();
                        short entryRowCount = PrestoSparkShufflePageInput.getShortLittleEndian(row.getArray(), row.getOffset());
                        rowCount += entryRowCount;
                        currentIteratorProcessedRows += (long)entryRowCount;
                        output.writeBytes(row.getArray(), row.getOffset() + 2, row.getLength() - 2);
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected PrestoSparkMutableRow: 'buffer' and 'array' fields are both null");
                }
                long end = System.currentTimeMillis();
                this.shuffleStats.accumulate(currentIteratorProcessedRows, currentIteratorProcessedRowBatches, currentIteratorProcessedBytes, end - start);
                if (iterator.hasNext()) break;
                this.shuffleStatsCollector.add((Object)new PrestoSparkShuffleStats(input.getFragmentId(), this.taskId, PrestoSparkShuffleStats.Operation.READ, this.shuffleStats.getProcessedRows(), this.shuffleStats.getProcessedRowBatches(), this.shuffleStats.getProcessedBytes(), this.shuffleStats.getElapsedWallTimeMills()));
                this.shuffleStats.reset();
                ++this.currentIteratorIndex;
            }
        }
        if (rowCount == 0) {
            return null;
        }
        return PrestoSparkShufflePageInput.createPage(rowCount, output.slice().getInput(), this.types);
    }

    private static Page createPage(int rowCount, BasicSliceInput input, List<Type> types) {
        Preconditions.checkArgument((rowCount > 0 ? 1 : 0) != 0, (String)"rowCount must be greater than zero: %s", (int)rowCount);
        if (input.length() == 0L) {
            Verify.verify((boolean)types.isEmpty(), (String)"types is expected to be empty", (Object[])new Object[0]);
            return new Page(rowCount, new Block[0]);
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        while (input.isReadable()) {
            pageBuilder.declarePosition();
            for (int channel = 0; channel < types.size(); ++channel) {
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(channel);
                blockBuilder.readPositionFrom((SliceInput)input);
            }
        }
        Page page = pageBuilder.build();
        Verify.verify((page.getPositionCount() == rowCount ? 1 : 0) != 0, (String)"unexpected row count: %s != %s", (int)page.getPositionCount(), (int)rowCount);
        return page;
    }

    private static short getShortLittleEndian(ByteBuffer byteBuffer) {
        byte leastSignificant = byteBuffer.get(byteBuffer.position());
        byte mostSignificant = byteBuffer.get(byteBuffer.position() + 1);
        return PrestoSparkShufflePageInput.getShort(leastSignificant, mostSignificant);
    }

    private static short getShortLittleEndian(byte[] bytes, int offset) {
        byte leastSignificant = bytes[offset];
        byte mostSignificant = bytes[offset + 1];
        return PrestoSparkShufflePageInput.getShort(leastSignificant, mostSignificant);
    }

    private static short getShort(byte leastSignificant, byte mostSignificant) {
        return (short)(leastSignificant & 0xFF | (mostSignificant & 0xFF) << 8);
    }

    private static class ShuffleStats {
        private long processedRows;
        private long processedRowBatches;
        private long processedBytes;
        private long elapsedWallTimeMills;

        private ShuffleStats() {
        }

        public void accumulate(long processedRows, long processedRowBatches, long processedBytes, long elapsedWallTimeMills) {
            this.processedRows += processedRows;
            this.processedRowBatches += processedRowBatches;
            this.processedBytes += processedBytes;
            this.elapsedWallTimeMills += elapsedWallTimeMills;
        }

        public void reset() {
            this.processedRows = 0L;
            this.processedRowBatches = 0L;
            this.processedBytes = 0L;
            this.elapsedWallTimeMills = 0L;
        }

        public long getProcessedRows() {
            return this.processedRows;
        }

        public long getProcessedRowBatches() {
            return this.processedRowBatches;
        }

        public long getProcessedBytes() {
            return this.processedBytes;
        }

        public long getElapsedWallTimeMills() {
            return this.elapsedWallTimeMills;
        }
    }
}

