/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.execution.PrestoSparkPageInput;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.page.PagesSerde;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public class PrestoSparkSerializedPageInput
implements PrestoSparkPageInput {
    private final PagesSerde pagesSerde;
    @GuardedBy(value="this")
    private final List<Iterator<PrestoSparkSerializedPage>> serializedPageIterators;
    @GuardedBy(value="this")
    private int currentIteratorIndex;

    public PrestoSparkSerializedPageInput(PagesSerde pagesSerde, List<Iterator<PrestoSparkSerializedPage>> serializedPageIterators) {
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.serializedPageIterators = Objects.requireNonNull(serializedPageIterators, "serializedPageIterator is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getNextPage() {
        PrestoSparkSerializedPage prestoSparkSerializedPage = null;
        PrestoSparkSerializedPageInput prestoSparkSerializedPageInput = this;
        synchronized (prestoSparkSerializedPageInput) {
            while (prestoSparkSerializedPage == null) {
                if (this.currentIteratorIndex >= this.serializedPageIterators.size()) {
                    return null;
                }
                Iterator<PrestoSparkSerializedPage> currentIterator = this.serializedPageIterators.get(this.currentIteratorIndex);
                if (currentIterator.hasNext()) {
                    prestoSparkSerializedPage = currentIterator.next();
                    continue;
                }
                ++this.currentIteratorIndex;
            }
        }
        return this.pagesSerde.deserialize(PrestoSparkUtils.toSerializedPage(prestoSparkSerializedPage));
    }
}

