/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.execution.PrestoSparkRemoteSourceOperator;
import com.facebook.presto.spark.execution.PrestoSparkSerializedPageInput;
import com.facebook.presto.spark.execution.PrestoSparkShuffleInput;
import com.facebook.presto.spark.execution.PrestoSparkShufflePageInput;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.spark.util.CollectionAccumulator;

public class PrestoSparkRemoteSourceFactory
implements RemoteSourceFactory {
    private final PagesSerde pagesSerde;
    private final Map<PlanNodeId, List<PrestoSparkShuffleInput>> shuffleInputsMap;
    private final Map<PlanNodeId, List<Iterator<PrestoSparkSerializedPage>>> pageInputsMap;
    private final int taskId;
    private final CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector;

    public PrestoSparkRemoteSourceFactory(PagesSerde pagesSerde, Map<PlanNodeId, List<PrestoSparkShuffleInput>> shuffleInputsMap, Map<PlanNodeId, List<Iterator<PrestoSparkSerializedPage>>> pageInputsMap, int taskId, CollectionAccumulator<PrestoSparkShuffleStats> shuffleStatsCollector) {
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.shuffleInputsMap = ImmutableMap.copyOf(Objects.requireNonNull(shuffleInputsMap, "shuffleInputsMap is null"));
        this.pageInputsMap = ImmutableMap.copyOf(Objects.requireNonNull(pageInputsMap, "pageInputs is null"));
        this.taskId = taskId;
        this.shuffleStatsCollector = Objects.requireNonNull(shuffleStatsCollector, "shuffleStatsCollector is null");
    }

    public SourceOperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
        List<PrestoSparkShuffleInput> shuffleInputs = this.shuffleInputsMap.get(planNodeId);
        List<Iterator<PrestoSparkSerializedPage>> pageInputs = this.pageInputsMap.get(planNodeId);
        Preconditions.checkArgument((shuffleInputs != null || pageInputs != null ? 1 : 0) != 0, (String)"input not found for plan node with id %s", (Object)planNodeId);
        Preconditions.checkArgument((shuffleInputs == null || pageInputs == null ? 1 : 0) != 0, (Object)"single remote source cannot accept both, shuffle and page inputs");
        if (pageInputs != null) {
            return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkSerializedPageInput(this.pagesSerde, pageInputs));
        }
        return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkShufflePageInput(types, shuffleInputs, this.taskId, this.shuffleStatsCollector));
    }

    public SourceOperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        throw new UnsupportedOperationException();
    }
}

