/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spark.PrestoSparkInjectorFactory;
import com.facebook.presto.spark.PrestoSparkService;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkService;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkServiceFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkConfiguration;
import com.facebook.presto.spark.classloader_interface.SparkProcessType;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;

public class PrestoSparkServiceFactory
implements IPrestoSparkServiceFactory {
    private final Logger log = Logger.get(PrestoSparkServiceFactory.class);

    public IPrestoSparkService createService(SparkProcessType sparkProcessType, PrestoSparkConfiguration configuration) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(configuration.getConfigProperties());
        properties.put((Object)"plugin.dir", (Object)configuration.getPluginsDirectoryPath());
        PrestoSparkInjectorFactory prestoSparkInjectorFactory = new PrestoSparkInjectorFactory(sparkProcessType, (Map<String, String>)properties.build(), configuration.getCatalogProperties(), configuration.getEventListenerProperties(), this.getSqlParserOptions(), this.getAdditionalModules());
        Injector injector = prestoSparkInjectorFactory.create();
        PrestoSparkService prestoSparkService = (PrestoSparkService)injector.getInstance(PrestoSparkService.class);
        this.log.info("Initialized");
        return prestoSparkService;
    }

    protected List<Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    protected SqlParserOptions getSqlParserOptions() {
        return new SqlParserOptions();
    }
}

