/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import javax.validation.constraints.NotNull;

public class PrestoSparkConfig {
    private boolean sparkPartitionCountAutoTuneEnabled = true;
    private int minSparkInputPartitionCountForAutoTune = 100;
    private int maxSparkInputPartitionCountForAutoTune = 1000;
    private int initialSparkPartitionCount = 16;
    private DataSize maxSplitsDataSizePerSparkPartition = new DataSize(2.0, DataSize.Unit.GIGABYTE);
    private DataSize shuffleOutputTargetAverageRowSize = new DataSize(1.0, DataSize.Unit.KILOBYTE);
    private boolean nullifyingIteratorForBroadcastJoinEnabled = true;

    public boolean isSparkPartitionCountAutoTuneEnabled() {
        return this.sparkPartitionCountAutoTuneEnabled;
    }

    @Config(value="spark.partition-count-auto-tune-enabled")
    @ConfigDescription(value="Automatic tuning of spark partition count based on max splits data size per partition")
    public PrestoSparkConfig setSparkPartitionCountAutoTuneEnabled(boolean sparkPartitionCountAutoTuneEnabled) {
        this.sparkPartitionCountAutoTuneEnabled = sparkPartitionCountAutoTuneEnabled;
        return this;
    }

    @Config(value="spark.min-spark-input-partition-count-for-auto-tune")
    @ConfigDescription(value="Minimal Spark input partition count when Spark partition auto tune is enabled")
    public PrestoSparkConfig setMinSparkInputPartitionCountForAutoTune(int minSparkInputPartitionCountForAutoTune) {
        this.minSparkInputPartitionCountForAutoTune = minSparkInputPartitionCountForAutoTune;
        return this;
    }

    public int getMinSparkInputPartitionCountForAutoTune() {
        return this.minSparkInputPartitionCountForAutoTune;
    }

    @Config(value="spark.max-spark-input-partition-count-for-auto-tune")
    @ConfigDescription(value="Max Spark input partition count when Spark partition auto tune is enabled")
    public PrestoSparkConfig setMaxSparkInputPartitionCountForAutoTune(int maxSparkInputPartitionCountForAutoTune) {
        this.maxSparkInputPartitionCountForAutoTune = maxSparkInputPartitionCountForAutoTune;
        return this;
    }

    public int getMaxSparkInputPartitionCountForAutoTune() {
        return this.maxSparkInputPartitionCountForAutoTune;
    }

    public int getInitialSparkPartitionCount() {
        return this.initialSparkPartitionCount;
    }

    @Config(value="spark.initial-partition-count")
    @ConfigDescription(value="Initial partition count for Spark RDD when reading table")
    public PrestoSparkConfig setInitialSparkPartitionCount(int initialPartitionCount) {
        this.initialSparkPartitionCount = initialPartitionCount;
        return this;
    }

    public DataSize getMaxSplitsDataSizePerSparkPartition() {
        return this.maxSplitsDataSizePerSparkPartition;
    }

    @Config(value="spark.max-splits-data-size-per-partition")
    @ConfigDescription(value="Maximal size in bytes for splits assigned to one partition")
    public PrestoSparkConfig setMaxSplitsDataSizePerSparkPartition(DataSize maxSplitsDataSizePerSparkPartition) {
        this.maxSplitsDataSizePerSparkPartition = maxSplitsDataSizePerSparkPartition;
        return this;
    }

    @NotNull
    public DataSize getShuffleOutputTargetAverageRowSize() {
        return this.shuffleOutputTargetAverageRowSize;
    }

    @Config(value="spark.shuffle-output-target-average-row-size")
    @ConfigDescription(value="Target average size for row entries produced by Presto on Spark for shuffle")
    public PrestoSparkConfig setShuffleOutputTargetAverageRowSize(DataSize shuffleOutputTargetAverageRowSize) {
        this.shuffleOutputTargetAverageRowSize = shuffleOutputTargetAverageRowSize;
        return this;
    }

    public boolean isNullifyingIteratorForBroadcastJoinEnabled() {
        return this.nullifyingIteratorForBroadcastJoinEnabled;
    }

    @Config(value="spark.nullifying-iterator-for-broadcast-join-enabled")
    @ConfigDescription(value="Enable nullifying iterator to optimize broadcast join memory footprint")
    public PrestoSparkConfig setNullifyingIteratorForBroadcastJoinEnabled(boolean nullifyingIteratorForBroadcastJoinEnabled) {
        this.nullifyingIteratorForBroadcastJoinEnabled = nullifyingIteratorForBroadcastJoinEnabled;
        return this;
    }
}

