/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.execution.PrestoSparkBufferedResult;
import com.google.common.base.Preconditions;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;
import scala.Tuple2;

public class PrestoSparkRowBatch
implements PrestoSparkBufferedResult {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PrestoSparkRowBatch.class).instanceSize();
    private static final int DEFAULT_TARGET_SIZE = 0x100000;
    private static final int DEFAULT_EXPECTED_ROWS_COUNT = 10000;
    private static final int REPLICATED_ROW_PARTITION_ID = -1;
    private final int partitionCount;
    private final int rowCount;
    private final byte[] rowData;
    private final int[] rowPartitions;
    private final int[] rowSizes;
    private final long retainedSizeInBytes;

    private PrestoSparkRowBatch(int partitionCount, int rowCount, byte[] rowData, int[] rowPartitions, int[] rowSizes) {
        this.partitionCount = partitionCount;
        this.rowCount = rowCount;
        this.rowData = Objects.requireNonNull(rowData, "rowData is null");
        this.rowPartitions = Objects.requireNonNull(rowPartitions, "rowPartitions is null");
        this.rowSizes = Objects.requireNonNull(rowSizes, "rowSizes is null");
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])rowData) + SizeOf.sizeOf((int[])rowPartitions) + SizeOf.sizeOf((int[])rowSizes);
    }

    public RowTupleSupplier createRowTupleSupplier() {
        return new RowTupleSupplier(this.partitionCount, this.rowCount, this.rowData, this.rowPartitions, this.rowSizes);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.rowCount;
    }

    public static PrestoSparkRowBatchBuilder builder(int partitionCount) {
        return new PrestoSparkRowBatchBuilder(partitionCount, 0x100000, 10000);
    }

    public static PrestoSparkRowBatchBuilder builder(int partitionCount, int targetSizeInBytes, int expectedRowsCount) {
        return new PrestoSparkRowBatchBuilder(partitionCount, targetSizeInBytes, expectedRowsCount);
    }

    public static class RowTupleSupplier {
        private final int partitionCount;
        private final int rowCount;
        private final int[] rowPartitions;
        private final int[] rowSizes;
        private int remainingReplicasCount;
        private int currentRow;
        private int currentOffset;
        private final ByteBuffer rowData;
        private final MutablePartitionId mutablePartitionId;
        private final Tuple2<MutablePartitionId, PrestoSparkMutableRow> tuple;

        private RowTupleSupplier(int partitionCount, int rowCount, byte[] rowData, int[] rowPartitions, int[] rowSizes) {
            this.partitionCount = partitionCount;
            this.rowCount = rowCount;
            this.rowPartitions = Objects.requireNonNull(rowPartitions, "rowPartitions is null");
            this.rowSizes = Objects.requireNonNull(rowSizes, "rowSizes is null");
            this.rowData = ByteBuffer.wrap(Objects.requireNonNull(rowData, "rowData is null"));
            this.mutablePartitionId = new MutablePartitionId();
            PrestoSparkMutableRow row = new PrestoSparkMutableRow();
            row.setBuffer(this.rowData);
            this.tuple = new Tuple2((Object)this.mutablePartitionId, (Object)row);
        }

        @Nullable
        public Tuple2<MutablePartitionId, PrestoSparkMutableRow> getNext() {
            if (this.currentRow >= this.rowCount) {
                return null;
            }
            int rowSize = this.rowSizes[this.currentRow];
            this.rowData.limit(this.currentOffset + rowSize);
            this.rowData.position(this.currentOffset);
            int partition = this.rowPartitions[this.currentRow];
            if (partition == -1) {
                if (this.remainingReplicasCount == 0) {
                    this.remainingReplicasCount = this.partitionCount;
                }
                this.mutablePartitionId.setPartition(this.remainingReplicasCount - 1);
                --this.remainingReplicasCount;
                if (this.remainingReplicasCount == 0) {
                    ++this.currentRow;
                    this.currentOffset += rowSize;
                }
            } else {
                this.mutablePartitionId.setPartition(partition);
                ++this.currentRow;
                this.currentOffset += rowSize;
            }
            return this.tuple;
        }
    }

    public static class PrestoSparkRowBatchBuilder {
        private static final int BUILDER_INSTANCE_SIZE = ClassLayout.parseClass(PrestoSparkRowBatchBuilder.class).instanceSize();
        private final int partitionCount;
        private final int targetSizeInBytes;
        private final DynamicSliceOutput sliceOutput;
        private int[] rowSizes;
        private int[] rowPartitions;
        private int rowCount;
        private int currentRowOffset;
        private boolean openEntry;

        private PrestoSparkRowBatchBuilder(int partitionCount, int targetSizeInBytes, int expectedRowsCount) {
            Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (String)"partitionCount must be greater then zero: %s", (int)partitionCount);
            this.partitionCount = partitionCount;
            this.targetSizeInBytes = targetSizeInBytes;
            this.sliceOutput = new DynamicSliceOutput((int)((float)targetSizeInBytes * 1.2f));
            this.rowSizes = new int[expectedRowsCount];
            this.rowPartitions = new int[expectedRowsCount];
        }

        public long getRetainedSizeInBytes() {
            return (long)BUILDER_INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + SizeOf.sizeOf((int[])this.rowSizes) + SizeOf.sizeOf((int[])this.rowPartitions);
        }

        public boolean isFull() {
            return this.sliceOutput.size() >= this.targetSizeInBytes;
        }

        public boolean isEmpty() {
            return this.rowCount == 0;
        }

        public SliceOutput beginRowEntry() {
            Preconditions.checkState((!this.openEntry ? 1 : 0) != 0, (Object)"previous entry must be closed before creating a new entry");
            this.openEntry = true;
            this.currentRowOffset = this.sliceOutput.size();
            return this.sliceOutput;
        }

        public void closeEntryForNonReplicatedRow(int partition) {
            this.closeEntry(partition);
        }

        public void closeEntryForReplicatedRow() {
            this.closeEntry(-1);
        }

        private void closeEntry(int partitionId) {
            Preconditions.checkState((boolean)this.openEntry, (Object)"entry must be opened first");
            this.openEntry = false;
            this.rowSizes = PrestoSparkRowBatchBuilder.ensureCapacity(this.rowSizes, this.rowCount + 1);
            this.rowSizes[this.rowCount] = this.sliceOutput.size() - this.currentRowOffset;
            this.rowPartitions = PrestoSparkRowBatchBuilder.ensureCapacity(this.rowPartitions, this.rowCount + 1);
            this.rowPartitions[this.rowCount] = partitionId;
            ++this.rowCount;
        }

        private static int[] ensureCapacity(int[] array, int capacity) {
            if (array.length >= capacity) {
                return array;
            }
            return Arrays.copyOf(array, capacity * 2);
        }

        public PrestoSparkRowBatch build() {
            Preconditions.checkState((!this.openEntry ? 1 : 0) != 0, (Object)"entry must be closed before creating a row batch");
            return new PrestoSparkRowBatch(this.partitionCount, this.rowCount, this.sliceOutput.getUnderlyingSlice().byteArray(), this.rowPartitions, this.rowSizes);
        }
    }
}

