/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.execution.PrestoSparkMutableRowPageInput;
import com.facebook.presto.spark.execution.PrestoSparkRemoteSourceOperator;
import com.facebook.presto.spark.execution.PrestoSparkSerializedPageInput;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import scala.Tuple2;
import scala.collection.Iterator;

public class PrestoSparkRemoteSourceFactory
implements RemoteSourceFactory {
    private final PagesSerde pagesSerde;
    private final Map<PlanNodeId, List<Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>>> rowInputsMap;
    private final Map<PlanNodeId, List<java.util.Iterator<PrestoSparkSerializedPage>>> pageInputsMap;

    public PrestoSparkRemoteSourceFactory(PagesSerde pagesSerde, Map<PlanNodeId, List<Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>>> rowInputsMap, Map<PlanNodeId, List<java.util.Iterator<PrestoSparkSerializedPage>>> pageInputsMap) {
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.rowInputsMap = Objects.requireNonNull(rowInputsMap, "rowInputs is null");
        this.pageInputsMap = Objects.requireNonNull(pageInputsMap, "pageInputs is null");
    }

    public SourceOperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
        List<Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> rowInputs = this.rowInputsMap.get(planNodeId);
        List<java.util.Iterator<PrestoSparkSerializedPage>> pageInputs = this.pageInputsMap.get(planNodeId);
        Preconditions.checkArgument((rowInputs != null || pageInputs != null ? 1 : 0) != 0, (String)"input not found for plan node with id %s", (Object)planNodeId);
        Preconditions.checkArgument((rowInputs == null || pageInputs == null ? 1 : 0) != 0, (Object)"single remote source cannot accept both, row and page inputs");
        if (pageInputs != null) {
            return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkSerializedPageInput(this.pagesSerde, pageInputs));
        }
        return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, new PrestoSparkMutableRowPageInput(types, rowInputs));
    }

    public SourceOperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        throw new UnsupportedOperationException();
    }
}

