/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.execution.PrestoSparkPageInput;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import scala.Tuple2;
import scala.collection.Iterator;

public class PrestoSparkMutableRowPageInput
implements PrestoSparkPageInput {
    private static final int TARGET_SIZE = 0x100000;
    private static final int BUFFER_SIZE = 0x133333;
    private static final int MAX_ROWS_PER_ZERO_COLUMN_PAGE = 10000;
    private final List<Type> types;
    @GuardedBy(value="this")
    private final List<Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> rowIterators;
    @GuardedBy(value="this")
    private int currentIteratorIndex;

    public PrestoSparkMutableRowPageInput(List<Type> types, List<Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>>> rowIterators) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.rowIterators = Objects.requireNonNull(rowIterators, "rowIterators is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page getNextPage() {
        if (this.types.isEmpty()) {
            int rowCount = 0;
            PrestoSparkMutableRowPageInput prestoSparkMutableRowPageInput = this;
            synchronized (prestoSparkMutableRowPageInput) {
                while (this.currentIteratorIndex < this.rowIterators.size() && rowCount < 10000) {
                    Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>> currentIterator = this.rowIterators.get(this.currentIteratorIndex);
                    if (currentIterator.hasNext()) {
                        currentIterator.next();
                        ++rowCount;
                        continue;
                    }
                    ++this.currentIteratorIndex;
                }
            }
            if (rowCount == 0) {
                return null;
            }
            return new Page(rowCount, new Block[0]);
        }
        DynamicSliceOutput output = new DynamicSliceOutput(0x133333);
        int rowCount = 0;
        PrestoSparkMutableRowPageInput currentIterator = this;
        synchronized (currentIterator) {
            while (this.currentIteratorIndex < this.rowIterators.size() && output.size() < 0x100000) {
                Iterator<Tuple2<MutablePartitionId, PrestoSparkMutableRow>> currentIterator2 = this.rowIterators.get(this.currentIteratorIndex);
                if (currentIterator2.hasNext()) {
                    PrestoSparkMutableRow row = (PrestoSparkMutableRow)((Tuple2)currentIterator2.next())._2;
                    if (row.getBuffer() != null) {
                        ByteBuffer buffer = row.getBuffer();
                        output.writeBytes(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
                    } else if (row.getArray() != null) {
                        output.writeBytes(row.getArray(), row.getOffset(), row.getLength());
                    } else {
                        throw new IllegalArgumentException("Unexpected PrestoSparkMutableRow: 'buffer' and 'array' fields are both null");
                    }
                    ++rowCount;
                    continue;
                }
                ++this.currentIteratorIndex;
            }
        }
        if (rowCount == 0) {
            return null;
        }
        BasicSliceInput sliceInput = output.slice().getInput();
        PageBuilder pageBuilder = new PageBuilder(this.types);
        while (sliceInput.isReadable()) {
            pageBuilder.declarePosition();
            for (int channel = 0; channel < this.types.size(); ++channel) {
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(channel);
                blockBuilder.readPositionFrom((SliceInput)sliceInput);
            }
        }
        Page page = pageBuilder.build();
        Verify.verify((page.getPositionCount() == rowCount ? 1 : 0) != 0, (String)"unexpected row count: %s != %s", (int)page.getPositionCount(), (int)rowCount);
        return page;
    }
}

