/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.spark.execution.PrestoSparkExecutionException;
import com.facebook.presto.spark.execution.PrestoSparkNonRetryableExecutionException;
import com.facebook.presto.spark.execution.PrestoSparkRetryableExecutionException;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.util.Failures;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.spark.SparkException;

public class PrestoSparkExecutionExceptionFactory {
    private static final Pattern PATTERN = Pattern.compile(".*\\| ExecutionFailureInfo\\[([^\\[\\]]+)\\] \\|.*", 40);
    private final JsonCodec<ExecutionFailureInfo> codec;

    @Inject
    public PrestoSparkExecutionExceptionFactory(JsonCodec<ExecutionFailureInfo> codec) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
    }

    public PrestoSparkExecutionException toPrestoSparkExecutionException(Throwable throwable) {
        ExecutionFailureInfo failureInfo = Failures.toFailure((Throwable)throwable);
        byte[] serialized = this.codec.toJsonBytes((Object)failureInfo);
        byte[] compressed = PrestoSparkUtils.compress(serialized);
        String encodedExecutionFailureInfo = Base64.getEncoder().encodeToString(compressed);
        if (PrestoSparkExecutionExceptionFactory.isRetryable(failureInfo)) {
            return new PrestoSparkRetryableExecutionException(throwable.getMessage(), encodedExecutionFailureInfo, throwable);
        }
        return new PrestoSparkNonRetryableExecutionException(throwable.getMessage(), encodedExecutionFailureInfo, throwable);
    }

    public Optional<ExecutionFailureInfo> extractExecutionFailureInfo(SparkException sparkException) {
        return this.extractExecutionFailureInfo(sparkException.getMessage());
    }

    public Optional<ExecutionFailureInfo> extractExecutionFailureInfo(PrestoSparkExecutionException executionException) {
        return this.extractExecutionFailureInfo(executionException.getMessage());
    }

    private Optional<ExecutionFailureInfo> extractExecutionFailureInfo(String message) {
        Matcher matcher = PATTERN.matcher(message);
        if (matcher.matches()) {
            String encodedFailureInfo = matcher.group(1);
            byte[] decoded = Base64.getDecoder().decode(encodedFailureInfo);
            byte[] decompressed = PrestoSparkUtils.decompress(decoded);
            ExecutionFailureInfo failureInfo = (ExecutionFailureInfo)this.codec.fromJson(decompressed);
            return Optional.of(failureInfo);
        }
        return Optional.empty();
    }

    private static boolean isRetryable(ExecutionFailureInfo executionFailureInfo) {
        ErrorCode errorCode = executionFailureInfo.getErrorCode();
        if (errorCode == null) {
            return true;
        }
        ErrorType type = errorCode.getType();
        return type == ErrorType.INTERNAL_ERROR || type == ErrorType.EXTERNAL;
    }
}

