/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spark.PrestoSparkConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public class PrestoSparkSessionProperties {
    public static final String SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED = "spark_partition_count_auto_tune_enabled";
    public static final String SPARK_INITIAL_PARTITION_COUNT = "spark_initial_partition_count";
    public static final String MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION = "max_splits_data_size_per_spark_partition";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PrestoSparkSessionProperties(PrestoSparkConfig prestoSparkConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED, (String)"Automatic tuning of spark initial partition count based on splits size per partition", (Boolean)prestoSparkConfig.isSparkPartitionCountAutoTuneEnabled(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPARK_INITIAL_PARTITION_COUNT, (String)"Initial partition count for Spark RDD when reading table", (Integer)prestoSparkConfig.getInitialSparkPartitionCount(), (boolean)false), (Object)new PropertyMetadata(MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION, "Maximal size in bytes for splits assigned to one partition", (Type)VarcharType.VARCHAR, DataSize.class, (Object)prestoSparkConfig.getMaxSplitsDataSizePerSparkPartition(), false, value -> DataSize.valueOf((String)((String)value)), DataSize::toString));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isSparkPartitionCountAutoTuneEnabled(Session session) {
        return (Boolean)session.getSystemProperty(SPARK_PARTITION_COUNT_AUTO_TUNE_ENABLED, Boolean.class);
    }

    public static int getSparkInitialPartitionCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_INITIAL_PARTITION_COUNT, Integer.class);
    }

    public static DataSize getMaxSplitsDataSizePerSparkPartition(Session session) {
        return (DataSize)session.getSystemProperty(MAX_SPLITS_DATA_SIZE_PER_SPARK_PARTITION, DataSize.class);
    }
}

