/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.server.SessionContext;
import com.facebook.presto.spark.PrestoSparkAuthenticatorProvider;
import com.facebook.presto.spark.PrestoSparkCredentialsProvider;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSession;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.session.ResourceEstimates;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class PrestoSparkSessionContext
implements SessionContext {
    private final Identity identity;
    private final String catalog;
    private final String schema;
    private final String source;
    private final String userAgent;
    private final String clientInfo;
    private final Set<String> clientTags;
    private final String timeZoneId;
    private final String language;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Optional<String> traceToken;

    public static PrestoSparkSessionContext createFromSessionInfo(PrestoSparkSession prestoSparkSession, Set<PrestoSparkCredentialsProvider> credentialsProviders, Set<PrestoSparkAuthenticatorProvider> authenticatorProviders) {
        ImmutableMap.Builder extraCredentials = ImmutableMap.builder();
        extraCredentials.putAll(prestoSparkSession.getExtraCredentials());
        credentialsProviders.forEach(provider -> extraCredentials.putAll(provider.getCredentials()));
        ImmutableMap.Builder extraTokenAuthenticators = ImmutableMap.builder();
        authenticatorProviders.forEach(provider -> extraTokenAuthenticators.putAll(provider.getTokenAuthenticators()));
        return new PrestoSparkSessionContext(new Identity(prestoSparkSession.getUser(), prestoSparkSession.getPrincipal(), (Map)ImmutableMap.of(), (Map)extraCredentials.build(), (Map)extraTokenAuthenticators.build()), prestoSparkSession.getCatalog().orElse(null), prestoSparkSession.getSchema().orElse(null), prestoSparkSession.getSource().orElse(null), prestoSparkSession.getUserAgent().orElse(null), prestoSparkSession.getClientInfo().orElse(null), prestoSparkSession.getClientTags(), prestoSparkSession.getTimeZoneId().orElse(null), prestoSparkSession.getLanguage().orElse(null), prestoSparkSession.getSystemProperties(), prestoSparkSession.getCatalogSessionProperties(), prestoSparkSession.getTraceToken());
    }

    public PrestoSparkSessionContext(Identity identity, String catalog, String schema, String source, String userAgent, String clientInfo, Set<String> clientTags, String timeZoneId, String language, Map<String, String> systemProperties, Map<String, Map<String, String>> catalogSessionProperties, Optional<String> traceToken) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.catalog = catalog;
        this.schema = schema;
        this.source = source;
        this.userAgent = userAgent;
        this.clientInfo = clientInfo;
        this.clientTags = ImmutableSet.copyOf((Collection)Objects.requireNonNull(clientTags, "clientTags is null"));
        this.timeZoneId = timeZoneId;
        this.language = language;
        this.systemProperties = ImmutableMap.copyOf(Objects.requireNonNull(systemProperties, "systemProperties is null"));
        this.catalogSessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(catalogSessionProperties, "catalogSessionProperties is null"));
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
    }

    public Identity getIdentity() {
        return this.identity;
    }

    @Nullable
    public String getCatalog() {
        return this.catalog;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    public String getRemoteUserAddress() {
        return "localhost";
    }

    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @Nullable
    public String getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public ResourceEstimates getResourceEstimates() {
        return new ResourceEstimates(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Nullable
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        return this.catalogSessionProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return ImmutableMap.of();
    }

    public Optional<TransactionId> getTransactionId() {
        return Optional.empty();
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public boolean supportClientTransaction() {
        return false;
    }
}

