/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.eventlistener.EventListenerModule;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.StaticCatalogStore;
import com.facebook.presto.metadata.StaticFunctionNamespaceStore;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AccessControlModule;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PrestoSystemRequirements;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.spark.PrestoSparkModule;
import com.facebook.presto.spark.classloader_interface.SparkProcessType;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrestoSparkInjectorFactory {
    private final SparkProcessType sparkProcessType;
    private final Map<String, String> configProperties;
    private final Map<String, Map<String, String>> catalogProperties;
    private final Optional<Map<String, String>> eventListenerProperties;
    private final SqlParserOptions sqlParserOptions;
    private final List<Module> additionalModules;
    private final Optional<Module> accessControlModuleOverride;

    public PrestoSparkInjectorFactory(SparkProcessType sparkProcessType, Map<String, String> configProperties, Map<String, Map<String, String>> catalogProperties, Optional<Map<String, String>> eventListenerProperties, SqlParserOptions sqlParserOptions, List<Module> additionalModules) {
        this(sparkProcessType, configProperties, catalogProperties, eventListenerProperties, sqlParserOptions, additionalModules, Optional.empty());
    }

    public PrestoSparkInjectorFactory(SparkProcessType sparkProcessType, Map<String, String> configProperties, Map<String, Map<String, String>> catalogProperties, Optional<Map<String, String>> eventListenerProperties, SqlParserOptions sqlParserOptions, List<Module> additionalModules, Optional<Module> accessControlModuleOverride) {
        this.sparkProcessType = Objects.requireNonNull(sparkProcessType, "sparkProcessType is null");
        this.configProperties = ImmutableMap.copyOf(Objects.requireNonNull(configProperties, "configProperties is null"));
        this.catalogProperties = (Map)Objects.requireNonNull(catalogProperties, "catalogProperties is null").entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.eventListenerProperties = Objects.requireNonNull(eventListenerProperties, "eventListenerProperties is null").map(ImmutableMap::copyOf);
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.additionalModules = ImmutableList.copyOf((Collection)Objects.requireNonNull(additionalModules, "additionalModules is null"));
        this.accessControlModuleOverride = Objects.requireNonNull(accessControlModuleOverride, "accessControlModuleOverride is null");
    }

    public Injector create() {
        PrestoSystemRequirements.verifySystemTimeIsReasonable();
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new JsonModule(), new EventListenerModule(), new PrestoSparkModule(this.sparkProcessType, this.sqlParserOptions)});
        boolean initializeAccessControl = false;
        if (this.accessControlModuleOverride.isPresent()) {
            modules.add((Object)this.accessControlModuleOverride.get());
        } else {
            modules.add((Object)new AccessControlModule());
            initializeAccessControl = true;
        }
        modules.addAll(this.additionalModules);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        app.doNotInitializeLogging();
        HashMap<String, String> requiredProperties = new HashMap<String, String>();
        requiredProperties.put("node.environment", "spark");
        requiredProperties.putAll(this.configProperties);
        app.setRequiredConfigurationProperties((Map)ImmutableMap.copyOf(requiredProperties));
        Injector injector = app.strictConfig().initialize();
        try {
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((StaticCatalogStore)injector.getInstance(StaticCatalogStore.class)).loadCatalogs(this.catalogProperties);
            ((StaticFunctionNamespaceStore)injector.getInstance(StaticFunctionNamespaceStore.class)).loadFunctionNamespaceManagers();
            ((SessionPropertyDefaults)injector.getInstance(SessionPropertyDefaults.class)).loadConfigurationManager();
            ((ResourceGroupManager)injector.getInstance(ResourceGroupManager.class)).loadConfigurationManager();
            ((PasswordAuthenticatorManager)injector.getInstance(PasswordAuthenticatorManager.class)).loadPasswordAuthenticator();
            this.eventListenerProperties.ifPresent(properties -> ((EventListenerManager)injector.getInstance(EventListenerManager.class)).loadConfiguredEventListener(properties));
            if (initializeAccessControl) {
                ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return injector;
    }
}

