/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;

public class PrestoSparkConfig {
    private boolean sparkPartitionCountAutoTuneEnabled = true;
    private int initialSparkPartitionCount = 16;
    private DataSize maxSplitsDataSizePerSparkPartition = new DataSize(2.0, DataSize.Unit.GIGABYTE);

    public boolean isSparkPartitionCountAutoTuneEnabled() {
        return this.sparkPartitionCountAutoTuneEnabled;
    }

    @Config(value="spark.partition-count-auto-tune-enabled")
    @ConfigDescription(value="Automatic tuning of spark partition count based on max splits data size per partition")
    public PrestoSparkConfig setSparkPartitionCountAutoTuneEnabled(boolean sparkPartitionCountAutoTuneEnabled) {
        this.sparkPartitionCountAutoTuneEnabled = sparkPartitionCountAutoTuneEnabled;
        return this;
    }

    public int getInitialSparkPartitionCount() {
        return this.initialSparkPartitionCount;
    }

    @Config(value="spark.initial-partition-count")
    @ConfigDescription(value="Initial partition count for Spark RDD when reading table")
    public PrestoSparkConfig setInitialSparkPartitionCount(int initialPartitionCount) {
        this.initialSparkPartitionCount = initialPartitionCount;
        return this;
    }

    public DataSize getMaxSplitsDataSizePerSparkPartition() {
        return this.maxSplitsDataSizePerSparkPartition;
    }

    @Config(value="spark.max-splits-data-size-per-partition")
    @ConfigDescription(value="Maximal size in bytes for splits assigned to one partition")
    public PrestoSparkConfig setMaxSplitsDataSizePerSparkPartition(DataSize maxSplitsDataSizePerSparkPartition) {
        this.maxSplitsDataSizePerSparkPartition = maxSplitsDataSizePerSparkPartition;
        return this;
    }
}

