/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.ByteStreams;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class PrestoSparkUtils {
    private PrestoSparkUtils() {
    }

    public static PrestoSparkSerializedPage toPrestoSparkSerializedPage(SerializedPage serializedPage) {
        Slice slice = serializedPage.getSlice();
        Preconditions.checkArgument((boolean)slice.hasByteArray(), (Object)"slice is expected to be based on a byte array");
        return new PrestoSparkSerializedPage(BlockUtil.compactArray((byte[])slice.byteArray(), (int)slice.byteArrayOffset(), (int)slice.length()), serializedPage.getPositionCount(), serializedPage.getUncompressedSizeInBytes(), serializedPage.getPageCodecMarkers());
    }

    public static SerializedPage toSerializedPage(PrestoSparkSerializedPage prestoSparkSerializedPage) {
        return new SerializedPage(Slices.wrappedBuffer((byte[])prestoSparkSerializedPage.getBytes()), prestoSparkSerializedPage.getPageCodecMarkers(), prestoSparkSerializedPage.getPositionCount(), prestoSparkSerializedPage.getUncompressedSizeInBytes());
    }

    public static <T> Iterator<T> getNullifyingIterator(final List<T> list) {
        return new AbstractIterator<T>(){
            private int index;

            protected T computeNext() {
                if (this.index >= list.size()) {
                    return this.endOfData();
                }
                Object element = list.get(this.index);
                list.set(this.index, null);
                ++this.index;
                return element;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] bytes) {
        try (DeflaterInputStream decompressor = new DeflaterInputStream(new ByteArrayInputStream(bytes));){
            byte[] byArray = ByteStreams.toByteArray((InputStream)decompressor);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] decompress(byte[] bytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InflaterOutputStream compressor = new InflaterOutputStream(output);){
            compressor.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output.toByteArray();
    }
}

