/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.util;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;

public class PrestoSparkUtils {
    private PrestoSparkUtils() {
    }

    public static Iterator<Page> transformRowsToPages(final Iterator<PrestoSparkRow> rows, final List<Type> types) {
        return new AbstractIterator<Page>(){

            protected Page computeNext() {
                if (!rows.hasNext()) {
                    return (Page)this.endOfData();
                }
                PageBuilder pageBuilder = new PageBuilder(types);
                while (rows.hasNext() && !pageBuilder.isFull()) {
                    PrestoSparkRow row = (PrestoSparkRow)rows.next();
                    BasicSliceInput sliceInput = new BasicSliceInput(Slices.wrappedBuffer((byte[])row.getBytes(), (int)0, (int)row.getLength()));
                    pageBuilder.declarePosition();
                    for (int channel = 0; channel < types.size(); ++channel) {
                        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(channel);
                        blockBuilder.readPositionFrom((SliceInput)sliceInput);
                    }
                    sliceInput.close();
                }
                Verify.verify((!pageBuilder.isEmpty() ? 1 : 0) != 0);
                return pageBuilder.build();
            }
        };
    }

    public static PrestoSparkSerializedPage toPrestoSparkSerializedPage(SerializedPage serializedPage) {
        Slice slice = serializedPage.getSlice();
        Preconditions.checkArgument((boolean)slice.hasByteArray(), (Object)"slice is expected to be based on a byte array");
        return new PrestoSparkSerializedPage(BlockUtil.compactArray((byte[])slice.byteArray(), (int)slice.byteArrayOffset(), (int)slice.length()), serializedPage.getPositionCount(), serializedPage.getUncompressedSizeInBytes(), serializedPage.getPageCodecMarkers());
    }

    public static SerializedPage toSerializedPage(PrestoSparkSerializedPage prestoSparkSerializedPage) {
        return new SerializedPage(Slices.wrappedBuffer((byte[])prestoSparkSerializedPage.getBytes()), prestoSparkSerializedPage.getPageCodecMarkers(), prestoSparkSerializedPage.getPositionCount(), prestoSparkSerializedPage.getUncompressedSizeInBytes());
    }

    public static <T> Iterator<T> getNullifyingIterator(final List<T> list) {
        return new AbstractIterator<T>(){
            private int index;

            protected T computeNext() {
                if (this.index >= list.size()) {
                    return this.endOfData();
                }
                Object element = list.get(this.index);
                list.set(this.index, null);
                ++this.index;
                return element;
            }
        };
    }
}

