/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.presto.Session;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LogicalPlanner;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanOptimizers;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class PrestoSparkQueryPlanner {
    private final SqlParser sqlParser;
    private final PlanOptimizers optimizers;
    private final QueryExplainer queryExplainer;
    private final Metadata metadata;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final AccessControl accessControl;

    @Inject
    public PrestoSparkQueryPlanner(SqlParser sqlParser, PlanOptimizers optimizers, QueryExplainer queryExplainer, Metadata metadata, StatsCalculator statsCalculator, CostCalculator costCalculator, AccessControl accessControl) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.optimizers = Objects.requireNonNull(optimizers, "optimizers is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public PlanAndUpdateType createQueryPlan(Session session, QueryPreparer.PreparedQuery preparedQuery, WarningCollector warningCollector) {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.accessControl, Optional.of(this.queryExplainer), preparedQuery.getParameters(), warningCollector);
        LogicalPlanner logicalPlanner = new LogicalPlanner(false, session, this.optimizers.get(), idAllocator, this.metadata, this.sqlParser, this.statsCalculator, this.costCalculator, warningCollector);
        Analysis analysis = analyzer.analyze(preparedQuery.getStatement());
        return new PlanAndUpdateType(logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED), Optional.ofNullable(analysis.getUpdateType()));
    }

    public static class PlanAndUpdateType {
        private final Plan plan;
        private final Optional<String> updateType;

        public PlanAndUpdateType(Plan plan, Optional<String> updateType) {
            this.plan = Objects.requireNonNull(plan, "plan is null");
            this.updateType = Objects.requireNonNull(updateType, "updateType is null");
        }

        public Plan getPlan() {
            return this.plan;
        }

        public Optional<String> getUpdateType() {
            return this.updateType;
        }
    }
}

