/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import org.openjdk.jol.info.ClassLayout;

public class PrestoSparkRowBuffer {
    private final OutputBufferMemoryManager memoryManager;
    private final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private final Queue<BufferedRows> buffer = new ArrayDeque<BufferedRows>();
    @GuardedBy(value="monitor")
    private boolean finished;

    public PrestoSparkRowBuffer(OutputBufferMemoryManager memoryManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    public ListenableFuture<?> isFull() {
        return this.memoryManager.getBufferBlockedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(BufferedRows rows) {
        Objects.requireNonNull(rows, "rows is null");
        Object object = this.monitor;
        synchronized (object) {
            this.buffer.add(rows);
            this.memoryManager.updateMemoryUsage((long)rows.getRetainedSizeInBytes());
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoMoreRows() {
        this.memoryManager.setNoBlockOnFull();
        Object object = this.monitor;
        synchronized (object) {
            this.finished = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrestoSparkRow> get() throws InterruptedException {
        BufferedRows bufferedRows = null;
        Object object = this.monitor;
        synchronized (object) {
            while (this.buffer.isEmpty() && !this.finished) {
                this.monitor.wait();
            }
            if (!this.buffer.isEmpty()) {
                bufferedRows = this.buffer.poll();
            }
            if (bufferedRows != null) {
                this.memoryManager.updateMemoryUsage((long)(-bufferedRows.getRetainedSizeInBytes()));
            }
        }
        if (bufferedRows == null) {
            return null;
        }
        return bufferedRows.getRows();
    }

    public static class BufferedRows {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(BufferedRows.class).instanceSize();
        private final List<PrestoSparkRow> rowsList;
        private final int rowsListRetainedSize;

        public BufferedRows(List<PrestoSparkRow> rowsList, int rowsListRetainedSize) {
            this.rowsList = ImmutableList.copyOf((Collection)Objects.requireNonNull(rowsList, "rowsList is null"));
            this.rowsListRetainedSize = rowsListRetainedSize;
        }

        public List<PrestoSparkRow> getRows() {
            return this.rowsList;
        }

        public int getRetainedSizeInBytes() {
            return INSTANCE_SIZE + this.rowsListRetainedSize;
        }
    }
}

