/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.common.Page;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class PrestoSparkRemoteSourceOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final Iterator<Page> iterator;
    private boolean finished;

    public PrestoSparkRemoteSourceOperator(PlanNodeId sourceId, OperatorContext operatorContext, Iterator<Page> iterator) {
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public boolean needsInput() {
        return false;
    }

    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        Iterator<Page> iterator = this.iterator;
        synchronized (iterator) {
            if (!this.iterator.hasNext()) {
                this.finished = true;
                return null;
            }
            return this.iterator.next();
        }
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        throw new UnsupportedOperationException();
    }

    public void noMoreSplits() {
        throw new UnsupportedOperationException();
    }

    public static class SparkRemoteSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Iterator<Page> iterator;
        private boolean closed;

        public SparkRemoteSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, Iterator<Page> iterator) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        }

        public PlanNodeId getSourceId() {
            return this.planNodeId;
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"operator factory is closed");
            return new PrestoSparkRemoteSourceOperator(this.planNodeId, driverContext.addOperatorContext(this.operatorId, this.planNodeId, PrestoSparkRemoteSourceOperator.class.getSimpleName()), this.iterator);
        }

        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

