/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.execution.PrestoSparkRemoteSourceOperator;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrestoSparkRemoteSourceFactory
implements RemoteSourceFactory {
    private final PagesSerde pagesSerde;
    private final Map<PlanNodeId, Iterator<PrestoSparkRow>> shuffleInputs;
    private final Map<PlanNodeId, Iterator<PrestoSparkSerializedPage>> broadcastInputs;

    public PrestoSparkRemoteSourceFactory(PagesSerde pagesSerde, Map<PlanNodeId, Iterator<PrestoSparkRow>> shuffleInputs, Map<PlanNodeId, Iterator<PrestoSparkSerializedPage>> broadcastInputs) {
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.shuffleInputs = ImmutableMap.copyOf(Objects.requireNonNull(shuffleInputs, "shuffleInputs is null"));
        this.broadcastInputs = ImmutableMap.copyOf(Objects.requireNonNull(broadcastInputs, "broadcastInputs is null"));
    }

    public OperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
        Iterator<PrestoSparkRow> shuffleInput = this.shuffleInputs.get(planNodeId);
        Iterator<PrestoSparkSerializedPage> broadcastInput = this.broadcastInputs.get(planNodeId);
        Preconditions.checkArgument((shuffleInput != null || broadcastInput != null ? 1 : 0) != 0, (String)"input not found for plan node with id %s", (Object)planNodeId);
        Preconditions.checkArgument((shuffleInput == null || broadcastInput == null ? 1 : 0) != 0, (Object)"single remote source cannot accept both, broadcast and shuffle inputs");
        if (broadcastInput != null) {
            return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, Iterators.transform(broadcastInput, sparkSerializedPage -> this.pagesSerde.deserialize(PrestoSparkUtils.toSerializedPage(sparkSerializedPage))));
        }
        return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, PrestoSparkUtils.transformRowsToPages(shuffleInput, types));
    }

    public OperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        throw new UnsupportedOperationException();
    }
}

