/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.spark.execution.PrestoSparkExecutionException;
import com.facebook.presto.spark.execution.PrestoSparkNonRetryableExecutionException;
import com.facebook.presto.spark.execution.PrestoSparkRetryableExecutionException;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.util.Failures;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.InflaterOutputStream;
import javax.inject.Inject;
import org.apache.spark.SparkException;

public class PrestoSparkExecutionExceptionFactory {
    private static final Pattern PATTERN = Pattern.compile(".*\\| ExecutionFailureInfo\\[([^\\[\\]]+)\\] \\|.*", 40);
    private final JsonCodec<ExecutionFailureInfo> codec;

    @Inject
    public PrestoSparkExecutionExceptionFactory(JsonCodec<ExecutionFailureInfo> codec) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
    }

    public PrestoSparkExecutionException toPrestoSparkExecutionException(Throwable throwable) {
        ExecutionFailureInfo failureInfo = Failures.toFailure((Throwable)throwable);
        byte[] serialized = this.codec.toJsonBytes((Object)failureInfo);
        byte[] compressed = PrestoSparkExecutionExceptionFactory.compress(serialized);
        String encodedExecutionFailureInfo = Base64.getEncoder().encodeToString(compressed);
        if (PrestoSparkExecutionExceptionFactory.isRetryable(failureInfo)) {
            return new PrestoSparkRetryableExecutionException(throwable.getMessage(), encodedExecutionFailureInfo, throwable);
        }
        return new PrestoSparkNonRetryableExecutionException(throwable.getMessage(), encodedExecutionFailureInfo, throwable);
    }

    public Optional<ExecutionFailureInfo> extractExecutionFailureInfo(SparkException sparkException) {
        return this.extractExecutionFailureInfo(sparkException.getMessage());
    }

    public Optional<ExecutionFailureInfo> extractExecutionFailureInfo(PrestoSparkExecutionException executionException) {
        return this.extractExecutionFailureInfo(executionException.getMessage());
    }

    private Optional<ExecutionFailureInfo> extractExecutionFailureInfo(String message) {
        Matcher matcher = PATTERN.matcher(message);
        if (matcher.matches()) {
            String encodedFailureInfo = matcher.group(1);
            byte[] decoded = Base64.getDecoder().decode(encodedFailureInfo);
            byte[] decompressed = PrestoSparkExecutionExceptionFactory.decompress(decoded);
            ExecutionFailureInfo failureInfo = (ExecutionFailureInfo)this.codec.fromJson(decompressed);
            return Optional.of(failureInfo);
        }
        return Optional.empty();
    }

    private static boolean isRetryable(ExecutionFailureInfo executionFailureInfo) {
        ErrorCode errorCode = executionFailureInfo.getErrorCode();
        if (errorCode == null) {
            return true;
        }
        ErrorType type = errorCode.getType();
        return type == ErrorType.INTERNAL_ERROR || type == ErrorType.EXTERNAL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] compress(byte[] bytes) {
        try (DeflaterInputStream decompressor = new DeflaterInputStream(new ByteArrayInputStream(bytes));){
            byte[] byArray = ByteStreams.toByteArray((InputStream)decompressor);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static byte[] decompress(byte[] bytes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (InflaterOutputStream compressor = new InflaterOutputStream(output);){
            compressor.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return output.toByteArray();
    }
}

