/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.scheduler.ExecutionWriterTarget;
import com.facebook.presto.execution.scheduler.StreamingPlanSection;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.QuerySessionSupplier;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.spark.PrestoSparkAuthenticatorProvider;
import com.facebook.presto.spark.PrestoSparkCredentialsProvider;
import com.facebook.presto.spark.PrestoSparkSessionContext;
import com.facebook.presto.spark.PrestoSparkSettingsRequirements;
import com.facebook.presto.spark.PrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkConfInitializer;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSession;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskInputs;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.SerializedTaskStats;
import com.facebook.presto.spark.classloader_interface.SparkProcessType;
import com.facebook.presto.spark.execution.PrestoSparkExecutionException;
import com.facebook.presto.spark.execution.PrestoSparkExecutionExceptionFactory;
import com.facebook.presto.spark.planner.PrestoSparkPlanFragmenter;
import com.facebook.presto.spark.planner.PrestoSparkQueryPlanner;
import com.facebook.presto.spark.planner.PrestoSparkRddFactory;
import com.facebook.presto.spark.util.PrestoSparkUtils;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorCapabilities;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.CollectionAccumulator;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public class PrestoSparkQueryExecutionFactory
implements IPrestoSparkQueryExecutionFactory {
    private static final Logger log = Logger.get(PrestoSparkQueryExecutionFactory.class);
    private final QueryIdGenerator queryIdGenerator;
    private final QuerySessionSupplier sessionSupplier;
    private final QueryPreparer queryPreparer;
    private final PrestoSparkQueryPlanner queryPlanner;
    private final PrestoSparkPlanFragmenter planFragmenter;
    private final PrestoSparkRddFactory rddFactory;
    private final QueryMonitor queryMonitor;
    private final JsonCodec<TaskStats> taskStatsJsonCodec;
    private final JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final BlockEncodingManager blockEncodingManager;
    private final PrestoSparkSettingsRequirements settingsRequirements;
    private final PrestoSparkExecutionExceptionFactory executionExceptionFactory;
    private final Set<PrestoSparkCredentialsProvider> credentialsProviders;
    private final Set<PrestoSparkAuthenticatorProvider> authenticatorProviders;

    @Inject
    public PrestoSparkQueryExecutionFactory(QueryIdGenerator queryIdGenerator, QuerySessionSupplier sessionSupplier, QueryPreparer queryPreparer, PrestoSparkQueryPlanner queryPlanner, PrestoSparkPlanFragmenter planFragmenter, PrestoSparkRddFactory rddFactory, QueryMonitor queryMonitor, JsonCodec<TaskStats> taskStatsJsonCodec, JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, BlockEncodingManager blockEncodingManager, PrestoSparkSettingsRequirements settingsRequirements, PrestoSparkExecutionExceptionFactory executionExceptionFactory, Set<PrestoSparkCredentialsProvider> credentialsProviders, Set<PrestoSparkAuthenticatorProvider> authenticatorProviders) {
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
        this.queryPlanner = Objects.requireNonNull(queryPlanner, "queryPlanner is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.rddFactory = Objects.requireNonNull(rddFactory, "rddFactory is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.taskStatsJsonCodec = Objects.requireNonNull(taskStatsJsonCodec, "taskStatsJsonCodec is null");
        this.sparkTaskDescriptorJsonCodec = Objects.requireNonNull(sparkTaskDescriptorJsonCodec, "sparkTaskDescriptorJsonCodec is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.settingsRequirements = Objects.requireNonNull(settingsRequirements, "settingsRequirements is null");
        this.executionExceptionFactory = Objects.requireNonNull(executionExceptionFactory, "executionExceptionFactory is null");
        this.credentialsProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(credentialsProviders, "credentialsProviders is null"));
        this.authenticatorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(authenticatorProviders, "authenticatorProviders is null"));
    }

    public IPrestoSparkQueryExecution create(SparkContext sparkContext, PrestoSparkSession prestoSparkSession, String sql, PrestoSparkTaskExecutorFactoryProvider executorFactoryProvider) {
        PrestoSparkConfInitializer.checkInitialized((SparkContext)sparkContext);
        QueryId queryId = this.queryIdGenerator.createNextQueryId();
        PrestoSparkSessionContext sessionContext = PrestoSparkSessionContext.createFromSessionInfo(prestoSparkSession, this.credentialsProviders, this.authenticatorProviders);
        WarningCollector warningCollector = WarningCollector.NOOP;
        Session session = this.sessionSupplier.createSession(queryId, (SessionContext)sessionContext);
        this.settingsRequirements.verify(sparkContext, session);
        TransactionId transactionId = this.transactionManager.beginTransaction(true);
        session = session.beginTransactionId(transactionId, this.transactionManager, this.accessControl);
        try {
            QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(session, sql, warningCollector);
            PrestoSparkQueryPlanner.PlanAndUpdateType planAndUpdateType = this.queryPlanner.createQueryPlan(session, preparedQuery, warningCollector);
            SubPlan fragmentedPlan = this.planFragmenter.fragmentQueryPlan(session, planAndUpdateType.getPlan(), warningCollector);
            log.info(PlanPrinter.textDistributedPlan((SubPlan)fragmentedPlan, (FunctionManager)this.metadata.getFunctionManager(), (Session)session, (boolean)true));
            TableWriteInfo tableWriteInfo = this.getTableWriteInfo(session, fragmentedPlan);
            JavaSparkContext javaSparkContext = new JavaSparkContext(sparkContext);
            CollectionAccumulator taskStatsCollector = new CollectionAccumulator();
            taskStatsCollector.register(sparkContext, (Option)new Some((Object)"taskStatsCollector"), false);
            return new PrestoSparkQueryExecution(javaSparkContext, session, this.queryMonitor, taskStatsCollector, executorFactoryProvider, fragmentedPlan, planAndUpdateType.getUpdateType(), this.taskStatsJsonCodec, this.sparkTaskDescriptorJsonCodec, this.rddFactory, tableWriteInfo, this.transactionManager, new PagesSerde((BlockEncodingSerde)this.blockEncodingManager, Optional.empty(), Optional.empty(), Optional.empty()), this.executionExceptionFactory);
        }
        catch (RuntimeException executionFailure) {
            try {
                PrestoSparkQueryExecutionFactory.rollback(session, this.transactionManager);
            }
            catch (RuntimeException rollbackFailure) {
                log.error((Throwable)rollbackFailure, "Encountered error when performing rollback");
            }
            if (executionFailure instanceof PrestoSparkExecutionException) {
                Optional<ExecutionFailureInfo> executionFailureInfo = this.executionExceptionFactory.extractExecutionFailureInfo((PrestoSparkExecutionException)executionFailure);
                Verify.verify((boolean)executionFailureInfo.isPresent());
                throw executionFailureInfo.get().toFailure();
            }
            throw executionFailure;
        }
    }

    private TableWriteInfo getTableWriteInfo(Session session, SubPlan plan) {
        StreamingPlanSection streamingPlanSection = StreamingPlanSection.extractStreamingSections((SubPlan)plan);
        StreamingSubPlan streamingSubPlan = streamingPlanSection.getPlan();
        TableWriteInfo tableWriteInfo = TableWriteInfo.createTableWriteInfo((StreamingSubPlan)streamingSubPlan, (Metadata)this.metadata, (Session)session);
        if (tableWriteInfo.getWriterTarget().isPresent()) {
            this.checkPageSinkCommitIsSupported(session, (ExecutionWriterTarget)tableWriteInfo.getWriterTarget().get());
        }
        return tableWriteInfo;
    }

    private void checkPageSinkCommitIsSupported(Session session, ExecutionWriterTarget writerTarget) {
        ConnectorId connectorId;
        if (writerTarget instanceof ExecutionWriterTarget.DeleteHandle) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "delete queries are not supported by presto on spark");
        }
        if (writerTarget instanceof ExecutionWriterTarget.CreateHandle) {
            connectorId = ((ExecutionWriterTarget.CreateHandle)writerTarget).getHandle().getConnectorId();
        } else if (writerTarget instanceof ExecutionWriterTarget.InsertHandle) {
            connectorId = ((ExecutionWriterTarget.InsertHandle)writerTarget).getHandle().getConnectorId();
        } else {
            throw new IllegalArgumentException("unexpected writer target type: " + writerTarget.getClass());
        }
        Verify.verify((connectorId != null ? 1 : 0) != 0, (String)"connectorId is null", (Object[])new Object[0]);
        Set connectorCapabilities = this.metadata.getConnectorCapabilities(session, connectorId);
        if (!connectorCapabilities.contains(ConnectorCapabilities.SUPPORTS_PAGE_SINK_COMMIT)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "catalog does not support page sink commit: " + connectorId);
        }
    }

    private static void commit(Session session, TransactionManager transactionManager) {
        MoreFutures.getFutureValue((Future)transactionManager.asyncCommit(PrestoSparkQueryExecutionFactory.getTransactionInfo(session, transactionManager).getTransactionId()));
    }

    private static void rollback(Session session, TransactionManager transactionManager) {
        MoreFutures.getFutureValue((Future)transactionManager.asyncAbort(PrestoSparkQueryExecutionFactory.getTransactionInfo(session, transactionManager).getTransactionId()));
    }

    private static TransactionInfo getTransactionInfo(Session session, TransactionManager transactionManager) {
        Optional transaction = session.getTransactionId().flatMap(arg_0 -> ((TransactionManager)transactionManager).getOptionalTransactionInfo(arg_0));
        Preconditions.checkState((boolean)transaction.isPresent(), (Object)"transaction is not present");
        Preconditions.checkState((boolean)((TransactionInfo)transaction.get()).isAutoCommitContext(), (Object)"transaction doesn't have auto commit context enabled");
        return (TransactionInfo)transaction.get();
    }

    private static class RddAndMore {
        private final JavaPairRDD<Integer, PrestoSparkRow> rdd;
        private final List<Broadcast<?>> broadcastDependencies;
        private boolean collected;

        private RddAndMore(JavaPairRDD<Integer, PrestoSparkRow> rdd, List<Broadcast<?>> broadcastDependencies) {
            this.rdd = Objects.requireNonNull(rdd, "rdd is null");
            this.broadcastDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(broadcastDependencies, "broadcastDependencies is null"));
        }

        public List<Tuple2<Integer, PrestoSparkRow>> collectAndDestroyDependencies() {
            Preconditions.checkState((!this.collected ? 1 : 0) != 0, (Object)"already collected");
            this.collected = true;
            List result = this.rdd.collect();
            this.broadcastDependencies.forEach(Broadcast::destroy);
            return result;
        }

        public JavaPairRDD<Integer, PrestoSparkRow> getRdd() {
            return this.rdd;
        }

        public List<Broadcast<?>> getBroadcastDependencies() {
            return this.broadcastDependencies;
        }
    }

    public static class PrestoSparkQueryExecution
    implements IPrestoSparkQueryExecution {
        private final JavaSparkContext sparkContext;
        private final Session session;
        private final QueryMonitor queryMonitor;
        private final CollectionAccumulator<SerializedTaskStats> taskStatsCollector;
        private final PrestoSparkTaskExecutorFactoryProvider executorFactoryProvider;
        private final SubPlan plan;
        private final Optional<String> updateType;
        private final JsonCodec<TaskStats> taskStatsJsonCodec;
        private final JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec;
        private final PrestoSparkRddFactory rddFactory;
        private final TableWriteInfo tableWriteInfo;
        private final TransactionManager transactionManager;
        private final PagesSerde pagesSerde;
        private final PrestoSparkExecutionExceptionFactory executionExceptionFactory;

        private PrestoSparkQueryExecution(JavaSparkContext sparkContext, Session session, QueryMonitor queryMonitor, CollectionAccumulator<SerializedTaskStats> taskStatsCollector, PrestoSparkTaskExecutorFactoryProvider executorFactoryProvider, SubPlan plan, Optional<String> updateType, JsonCodec<TaskStats> taskStatsJsonCodec, JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec, PrestoSparkRddFactory rddFactory, TableWriteInfo tableWriteInfo, TransactionManager transactionManager, PagesSerde pagesSerde, PrestoSparkExecutionExceptionFactory executionExceptionFactory) {
            this.sparkContext = Objects.requireNonNull(sparkContext, "sparkContext is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
            this.taskStatsCollector = Objects.requireNonNull(taskStatsCollector, "taskStatsCollector is null");
            this.executorFactoryProvider = Objects.requireNonNull(executorFactoryProvider, "executorFactoryProvider is null");
            this.plan = Objects.requireNonNull(plan, "plan is null");
            this.updateType = updateType;
            this.taskStatsJsonCodec = Objects.requireNonNull(taskStatsJsonCodec, "taskStatsJsonCodec is null");
            this.sparkTaskDescriptorJsonCodec = Objects.requireNonNull(sparkTaskDescriptorJsonCodec, "sparkTaskDescriptorJsonCodec is null");
            this.rddFactory = Objects.requireNonNull(rddFactory, "rddFactory is null");
            this.tableWriteInfo = Objects.requireNonNull(tableWriteInfo, "tableWriteInfo is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
            this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
            this.executionExceptionFactory = Objects.requireNonNull(executionExceptionFactory, "executionExceptionFactory is null");
        }

        public List<List<Object>> execute() {
            List<Tuple2<Integer, PrestoSparkRow>> rddResults;
            try {
                rddResults = this.doExecute(this.plan);
                PrestoSparkQueryExecutionFactory.commit(this.session, this.transactionManager);
            }
            catch (Exception executionFailure) {
                Optional<ExecutionFailureInfo> executionFailureInfo;
                try {
                    PrestoSparkQueryExecutionFactory.rollback(this.session, this.transactionManager);
                }
                catch (RuntimeException rollbackFailure) {
                    log.error((Throwable)rollbackFailure, "Encountered error when performing rollback");
                }
                try {
                    this.queryCompletedEvent(Optional.of(executionFailure));
                }
                catch (RuntimeException eventFailure) {
                    log.error((Throwable)eventFailure, "Error publishing query completed event");
                }
                if (executionFailure instanceof SparkException) {
                    executionFailureInfo = this.executionExceptionFactory.extractExecutionFailureInfo((SparkException)executionFailure);
                    if (executionFailureInfo.isPresent()) {
                        throw executionFailureInfo.get().toFailure();
                    }
                    throw Failures.toFailure((Throwable)executionFailure).toFailure();
                }
                if (executionFailure instanceof PrestoSparkExecutionException) {
                    executionFailureInfo = this.executionExceptionFactory.extractExecutionFailureInfo((PrestoSparkExecutionException)executionFailure);
                    Verify.verify((boolean)executionFailureInfo.isPresent());
                    throw executionFailureInfo.get().toFailure();
                }
                throw Failures.toFailure((Throwable)executionFailure).toFailure();
            }
            this.queryCompletedEvent(Optional.empty());
            ConnectorSession connectorSession = this.session.toConnectorSession();
            List types = this.plan.getFragment().getTypes();
            ImmutableList.Builder result = ImmutableList.builder();
            for (Tuple2<Integer, PrestoSparkRow> tuple : rddResults) {
                PrestoSparkRow row = (PrestoSparkRow)tuple._2;
                BasicSliceInput sliceInput = new BasicSliceInput(Slices.wrappedBuffer((byte[])row.getBytes(), (int)0, (int)row.getLength()));
                ArrayList<Object> columns = new ArrayList<Object>();
                for (Type type : types) {
                    BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
                    blockBuilder.readPositionFrom((SliceInput)sliceInput);
                    columns.add(type.getObjectValue(connectorSession.getSqlFunctionProperties(), (Block)blockBuilder, 0));
                }
                result.add(Collections.unmodifiableList(columns));
            }
            return result.build();
        }

        public List<Type> getOutputTypes() {
            return this.plan.getFragment().getTypes();
        }

        public Optional<String> getUpdateType() {
            return this.updateType;
        }

        private List<Tuple2<Integer, PrestoSparkRow>> doExecute(SubPlan root) throws SparkException {
            PlanFragment rootFragment = root.getFragment();
            if (rootFragment.getPartitioning().equals((Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
                PrestoSparkTaskDescriptor taskDescriptor = new PrestoSparkTaskDescriptor(this.session.toSessionRepresentation(), this.session.getIdentity().getExtraCredentials(), rootFragment, (List<TaskSource>)ImmutableList.of(), this.tableWriteInfo);
                SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor = new SerializedPrestoSparkTaskDescriptor(this.sparkTaskDescriptorJsonCodec.toJsonBytes((Object)taskDescriptor));
                Map inputRdds = (Map)root.getChildren().stream().collect(ImmutableMap.toImmutableMap(child -> child.getFragment().getId(), this::createRdd));
                Map inputFutures = (Map)inputRdds.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((PlanFragmentId)entry.getKey()).toString(), entry -> ((RddAndMore)entry.getValue()).getRdd().collectAsync()));
                PrestoSparkQueryExecution.waitFor(inputFutures.values());
                Map inputs = (Map)inputFutures.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((List)Futures.getUnchecked((Future)((Future)entry.getValue()))).iterator()));
                return ImmutableList.copyOf((Iterator)this.executorFactoryProvider.get(SparkProcessType.DRIVER).create(0, 0, serializedTaskDescriptor, new PrestoSparkTaskInputs(inputs, (Map)ImmutableMap.of()), this.taskStatsCollector));
            }
            RddAndMore rootRdd = this.createRdd(root);
            return rootRdd.collectAndDestroyDependencies();
        }

        private RddAndMore createRdd(SubPlan subPlan) {
            ImmutableMap.Builder rddInputs = ImmutableMap.builder();
            ImmutableMap.Builder broadcastInputs = ImmutableMap.builder();
            ImmutableList.Builder broadcastDependencies = ImmutableList.builder();
            for (SubPlan child : subPlan.getChildren()) {
                PlanFragment childFragment = child.getFragment();
                RddAndMore childRdd = this.createRdd(child);
                if (childFragment.getPartitioningScheme().getPartitioning().getHandle().equals((Object)SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
                    List<Tuple2<Integer, PrestoSparkRow>> broadcastRows = childRdd.collectAndDestroyDependencies();
                    Iterator<Page> pagesIterator = PrestoSparkUtils.transformRowsToPages(Iterators.transform(broadcastRows.iterator(), Tuple2::_2), childFragment.getTypes());
                    Iterator serializedPagesIterator = Iterators.transform((Iterator)Iterators.transform(pagesIterator, arg_0 -> ((PagesSerde)this.pagesSerde).serialize(arg_0)), PrestoSparkUtils::toPrestoSparkSerializedPage);
                    ArrayList serializedPages = new ArrayList();
                    serializedPagesIterator.forEachRemaining(serializedPages::add);
                    Broadcast broadcast = this.sparkContext.broadcast(serializedPages);
                    broadcastInputs.put((Object)childFragment.getId(), (Object)broadcast);
                    broadcastDependencies.add((Object)broadcast);
                    continue;
                }
                rddInputs.put((Object)childFragment.getId(), childRdd.getRdd());
                broadcastDependencies.addAll(childRdd.getBroadcastDependencies());
            }
            JavaPairRDD<Integer, PrestoSparkRow> rdd = this.rddFactory.createSparkRdd(this.sparkContext, this.session, subPlan.getFragment(), (Map<PlanFragmentId, JavaPairRDD<Integer, PrestoSparkRow>>)rddInputs.build(), (Map<PlanFragmentId, Broadcast<List<PrestoSparkSerializedPage>>>)broadcastInputs.build(), this.executorFactoryProvider, this.taskStatsCollector, this.tableWriteInfo);
            return new RddAndMore(rdd, (List)broadcastDependencies.build());
        }

        private void queryCompletedEvent(Optional<Throwable> failure) {
        }

        private QueryInfo createQueryInfo(Optional<Throwable> failure) {
            List serializedTaskStats = this.taskStatsCollector.value();
            List taskStats = (List)serializedTaskStats.stream().map(SerializedTaskStats::getBytes).map(arg_0 -> this.taskStatsJsonCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
            return null;
        }

        private static <T> void waitFor(Collection<Future<T>> futures) throws SparkException {
            try {
                for (Future<T> future : futures) {
                    future.get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwables.propagateIfPossible((Throwable)e.getCause(), SparkException.class);
                Throwables.propagateIfPossible((Throwable)e.getCause(), RuntimeException.class);
                throw new UncheckedExecutionException(e.getCause());
            }
            finally {
                for (Future<T> future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
        }
    }
}

