/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.discovery.EmbeddedDiscoveryModule;
import com.facebook.presto.execution.NodeSchedulerConfig;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.server.CodeCacheGcTrigger;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PrestoJvmRequirements;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.ServerMainModule;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.event.client.HttpEventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.floatingdecimal.FloatingDecimal;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.jmx.JmxModule;
import io.airlift.json.JsonModule;
import io.airlift.log.LogJmxModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class PrestoServer
implements Runnable {
    public static void main(String[] args) {
        new PrestoServer().run();
    }

    @Override
    public void run() {
        PrestoJvmRequirements.verifyJvmRequirements();
        Logger log = Logger.get(PrestoServer.class);
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), new JaxrsModule(), new MBeanModule(), new JmxModule(), new JmxHttpModule(), new LogJmxModule(), new TraceTokenModule(), new JsonEventModule(), new HttpEventModule(), new EmbeddedDiscoveryModule(), new ServerMainModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.strictConfig().initialize();
            if (!FloatingDecimal.isPatchInstalled()) {
                log.warn("FloatingDecimal patch not installed. Parallelism will be diminished when parsing/formatting doubles");
            }
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((CatalogManager)injector.getInstance(CatalogManager.class)).loadCatalogs();
            PrestoServer.updateDatasources((Announcer)injector.getInstance(Announcer.class), (Metadata)injector.getInstance(Metadata.class), (ServerConfig)injector.getInstance(ServerConfig.class), (NodeSchedulerConfig)injector.getInstance(NodeSchedulerConfig.class));
            ((Announcer)injector.getInstance(Announcer.class)).start();
            log.info("======== SERVER STARTED ========");
            CodeCacheGcTrigger.installCodeCacheGcTrigger();
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    private static void updateDatasources(Announcer announcer, Metadata metadata, ServerConfig serverConfig, NodeSchedulerConfig schedulerConfig) {
        ServiceAnnouncement announcement = PrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        String property = Strings.nullToEmpty((String)((String)announcement.getProperties().get("datasources")));
        List values = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property);
        LinkedHashSet<String> datasources = new LinkedHashSet<String>(values);
        if (datasources.isEmpty()) {
            Set catalogs = metadata.getCatalogNames().keySet();
            if (serverConfig.isCoordinator() && !schedulerConfig.isIncludeCoordinator()) {
                if (catalogs.contains("jmx")) {
                    datasources.add("jmx");
                }
            } else {
                datasources.addAll(catalogs);
            }
        }
        ServiceAnnouncement.ServiceAnnouncementBuilder builder = ServiceAnnouncement.serviceAnnouncement((String)announcement.getType());
        for (Map.Entry entry : announcement.getProperties().entrySet()) {
            if (((String)entry.getKey()).equals("datasources")) continue;
            builder.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        builder.addProperty("datasources", Joiner.on((char)',').join(datasources));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(builder.build());
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new IllegalArgumentException("Presto announcement not found: " + announcements);
    }
}

