/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.sql.analyzer.Session;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.net.URI;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class BasicQueryInfo {
    private final QueryId queryId;
    private final Session session;
    private final QueryState state;
    private final URI self;
    private final String query;
    private final Duration elapsedTime;
    private final DateTime endTime;
    private final DateTime createTime;
    private final int runningDrivers;
    private final int queuedDrivers;
    private final int completedDrivers;
    private final int totalDrivers;

    @JsonCreator
    public BasicQueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") Session session, @JsonProperty(value="state") QueryState state, @JsonProperty(value="self") URI self, @JsonProperty(value="query") String query, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="totalDrivers") int totalDrivers) {
        this.queryId = (QueryId)Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        this.session = (Session)Preconditions.checkNotNull((Object)session, (Object)"session is null");
        this.state = (QueryState)Preconditions.checkNotNull((Object)state, (Object)"state is null");
        this.self = (URI)Preconditions.checkNotNull((Object)self, (Object)"self is null");
        this.query = (String)Preconditions.checkNotNull((Object)query, (Object)"query is null");
        this.elapsedTime = elapsedTime;
        this.endTime = endTime;
        this.createTime = createTime;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is less than zero");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is less than zero");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is less than zero");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is less than zero");
        this.totalDrivers = totalDrivers;
    }

    public BasicQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), queryInfo.getSelf(), queryInfo.getQuery(), queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getEndTime(), queryInfo.getQueryStats().getCreateTime(), queryInfo.getQueryStats().getRunningDrivers(), queryInfo.getQueryStats().getQueuedDrivers(), queryInfo.getQueryStats().getCompletedDrivers(), queryInfo.getQueryStats().getTotalDrivers());
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public Session getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

