/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.client.QueryResults;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.NativeConnectorFactory;
import com.facebook.presto.connector.dual.DualModule;
import com.facebook.presto.connector.informationSchema.InformationSchemaModule;
import com.facebook.presto.connector.jmx.JmxConnectorFactory;
import com.facebook.presto.connector.system.SystemTablesModule;
import com.facebook.presto.event.query.QueryCompletionEvent;
import com.facebook.presto.event.query.QueryCreatedEvent;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.event.query.SplitCompletionEvent;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.guice.AbstractConfigurationAwareModule;
import com.facebook.presto.guice.ConditionalModule;
import com.facebook.presto.guice.DbiProvider;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.CatalogManagerConfig;
import com.facebook.presto.metadata.DatabaseLocalStorageManager;
import com.facebook.presto.metadata.DatabaseLocalStorageManagerConfig;
import com.facebook.presto.metadata.ForLocalStorageManager;
import com.facebook.presto.metadata.ForMetadata;
import com.facebook.presto.metadata.ForShardManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.LocalStorageManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.NodeVersion;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ExchangeClientFactory;
import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.server.CoordinatorModule;
import com.facebook.presto.server.ExecuteResource;
import com.facebook.presto.server.ForExecute;
import com.facebook.presto.server.HttpLocationFactory;
import com.facebook.presto.server.HttpRemoteTaskFactory;
import com.facebook.presto.server.NodeResource;
import com.facebook.presto.server.PagesMapper;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.PrestoServer;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.StatementResource;
import com.facebook.presto.server.TaskResource;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.Split;
import com.facebook.presto.split.DataStreamManager;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Serialization;
import com.facebook.presto.util.Threads;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.dbpool.H2EmbeddedDataSource;
import io.airlift.dbpool.H2EmbeddedDataSourceConfig;
import io.airlift.dbpool.H2EmbeddedDataSourceModule;
import io.airlift.dbpool.MySqlDataSourceModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.event.client.EventBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.Duration;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;
import org.weakref.jmx.guice.ExportBinder;

public class ServerMainModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ServerConfig serverConfig = (ServerConfig)this.buildConfigObject(ServerConfig.class);
        this.install((ConfigurationAwareModule)new CoordinatorModule());
        if (serverConfig.isCoordinator()) {
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto-coordinator");
        }
        ServerMainModule.bindFailureDetector(binder, serverConfig.isCoordinator());
        binder.bind(TaskResource.class).in(Scopes.SINGLETON);
        binder.bind(TaskManager.class).to(SqlTaskManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskManager.class).withGeneratedName();
        binder.bind(TaskExecutor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskExecutor.class).withGeneratedName();
        binder.bind(LocalExecutionPlanner.class).in(Scopes.SINGLETON);
        binder.bind(ExpressionCompiler.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(TaskManagerConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        binder.bind(PagesMapper.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Supplier<ExchangeClient>>(){}).to(ExchangeClientFactory.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("exchange", ForExchange.class).withTracing();
        ConfigurationModule.bindConfig((Binder)binder).to(ExchangeClientConfig.class);
        binder.bind(LocationFactory.class).to(HttpLocationFactory.class).in(Scopes.SINGLETON);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("scheduler", ForScheduler.class).withTracing();
        ConfigurationModule.bindConfig((Binder)binder).to(DatabaseLocalStorageManagerConfig.class);
        binder.bind(LocalStorageManager.class).to(DatabaseLocalStorageManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(LocalStorageManager.class).withGeneratedName();
        binder.bind(DataStreamManager.class).in(Scopes.SINGLETON);
        binder.bind(DataStreamProvider.class).to(DataStreamManager.class).in(Scopes.SINGLETON);
        binder.bind(CatalogManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(CatalogManagerConfig.class);
        binder.bind(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(Metadata.class).to(MetadataManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new HandleJsonModule());
        binder.bind(ConnectorManager.class).in(Scopes.SINGLETON);
        MapBinder connectorFactoryBinder = MapBinder.newMapBinder((Binder)binder, String.class, ConnectorFactory.class);
        connectorFactoryBinder.addBinding((Object)"native").to(NativeConnectorFactory.class);
        connectorFactoryBinder.addBinding((Object)"jmx").to(JmxConnectorFactory.class);
        binder.install((Module)new DualModule());
        binder.install((Module)new InformationSchemaModule());
        binder.install((Module)new SystemTablesModule());
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(Split.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Expression.class).to(Serialization.ExpressionSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Expression.class).to(Serialization.ExpressionDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(FunctionCall.class).to(Serialization.FunctionCallDeserializer.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{QueryCreatedEvent.class});
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{QueryCompletionEvent.class});
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{SplitCompletionEvent.class});
        String prestoVersion = serverConfig.getPrestoVersion();
        if (prestoVersion == null) {
            prestoVersion = ServerMainModule.detectPrestoVersion();
        }
        Preconditions.checkState((prestoVersion != null ? 1 : 0) != 0, (Object)"presto.version must be provided when it cannot be automatically determined");
        NodeVersion nodeVersion = new NodeVersion(prestoVersion);
        binder.bind(NodeVersion.class).toInstance((Object)nodeVersion);
        ServiceAnnouncement.ServiceAnnouncementBuilder prestoAnnouncement = DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto").addProperty("node_version", nodeVersion.toString());
        if (serverConfig.getDataSources() != null) {
            prestoAnnouncement.addProperty("datasources", serverConfig.getDataSources());
        }
        this.bindDataSource(binder, "presto-metastore", ForMetadata.class, ForShardManager.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryResults.class);
        binder.bind(StatementResource.class).in(Scopes.SINGLETON);
        binder.bind(ExecuteResource.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("execute", ForExecute.class);
        binder.bind(PluginManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(PluginManagerConfig.class);
        binder.bind((TypeLiteral)new TypeLiteral<List<PlanOptimizer>>(){}).toProvider(PlanOptimizersFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForExchange
    public Executor createExchangeExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"exchange-callback-%s"));
    }

    @Provides
    @Singleton
    @ForLocalStorageManager
    public IDBI createLocalStorageManagerDBI(DatabaseLocalStorageManagerConfig config) throws Exception {
        return new DBI((DataSource)new H2EmbeddedDataSource((H2EmbeddedDataSourceConfig)((H2EmbeddedDataSourceConfig)new H2EmbeddedDataSourceConfig().setFilename(new File(config.getDataDirectory(), "db/StorageManager").getAbsolutePath()).setMaxConnections(500)).setMaxConnectionWait(new Duration(1.0, TimeUnit.SECONDS))));
    }

    @SafeVarargs
    private final void bindDataSource(Binder binder, String type, Class<? extends Annotation> annotation, Class<? extends Annotation> ... aliases) {
        String property = type + ".db.type";
        this.install(ConditionalModule.installIfPropertyEquals((Module)new MySqlDataSourceModule(type, annotation, (Class[])aliases), (String)property, (String)"mysql"));
        this.install(ConditionalModule.installIfPropertyEquals((Module)new H2EmbeddedDataSourceModule(type, annotation, (Class[])aliases), (String)property, (String)"h2"));
        DbiProvider.bindDbiToDataSource((Binder)binder, annotation);
        for (Class<? extends Annotation> alias : aliases) {
            DbiProvider.bindDbiToDataSource((Binder)binder, alias);
        }
    }

    private static String detectPrestoVersion() {
        String title = PrestoServer.class.getPackage().getImplementationTitle();
        String version = PrestoServer.class.getPackage().getImplementationVersion();
        return title == null || version == null ? null : title + ":" + version;
    }

    private static void bindFailureDetector(Binder binder, boolean coordinator) {
        if (coordinator) {
            binder.install((Module)new FailureDetectorModule());
            binder.bind(NodeResource.class).in(Scopes.SINGLETON);
        } else {
            binder.bind(FailureDetector.class).toInstance((Object)new FailureDetector(){

                public Set<ServiceDescriptor> getFailed() {
                    return ImmutableSet.of();
                }
            });
        }
    }
}

