/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.metadata.LocalStorageManager;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@Path(value="/v1/shard")
public class ShardResource {
    private final LocalStorageManager storageManager;

    @Inject
    public ShardResource(LocalStorageManager storageManager) {
        this.storageManager = (LocalStorageManager)Preconditions.checkNotNull((Object)storageManager, (Object)"storageManager is null");
    }

    @DELETE
    @Path(value="{shardId: \\d+}")
    public Response dropShard(@PathParam(value="shardId") long shardId) {
        this.storageManager.dropShard(shardId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="{shardId: \\d+}")
    public Response shardStatus(@PathParam(value="shardId") long shardId) {
        if (this.storageManager.isShardActive(shardId)) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        if (this.storageManager.shardExists(shardId)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

