/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.CreateAliasExecution;
import com.facebook.presto.execution.DropAliasExecution;
import com.facebook.presto.execution.DropTableExecution;
import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.NodeSchedulerConfig;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.SqlQueryExecution;
import com.facebook.presto.execution.SqlQueryManager;
import com.facebook.presto.guice.AbstractConfigurationAwareModule;
import com.facebook.presto.importer.DatabasePeriodicImportManager;
import com.facebook.presto.importer.ForPeriodicImport;
import com.facebook.presto.importer.JobStateFactory;
import com.facebook.presto.importer.PeriodicImportConfig;
import com.facebook.presto.importer.PeriodicImportController;
import com.facebook.presto.importer.PeriodicImportManager;
import com.facebook.presto.importer.PeriodicImportRunnable;
import com.facebook.presto.metadata.AliasDao;
import com.facebook.presto.metadata.DatabaseShardManager;
import com.facebook.presto.metadata.DiscoveryNodeManager;
import com.facebook.presto.metadata.ForMetadata;
import com.facebook.presto.metadata.ForShardCleaner;
import com.facebook.presto.metadata.NodeManager;
import com.facebook.presto.metadata.ShardCleaner;
import com.facebook.presto.metadata.ShardCleanerConfig;
import com.facebook.presto.metadata.ShardManager;
import com.facebook.presto.server.PeriodicImportJobResource;
import com.facebook.presto.server.QueryResource;
import com.facebook.presto.server.ShardResource;
import com.facebook.presto.server.StageResource;
import com.facebook.presto.split.NativeDataStreamProvider;
import com.facebook.presto.split.NativeSplitManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.tree.CreateAlias;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.DropAlias;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.storage.DatabaseStorageManager;
import com.facebook.presto.storage.StorageManager;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerBinder;
import javax.inject.Singleton;
import org.skife.jdbi.v2.IDBI;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource("/", "webapp").withWelcomeFile("index.html");
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
        binder.bind(QueryResource.class).in(Scopes.SINGLETON);
        binder.bind(StageResource.class).in(Scopes.SINGLETON);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryManager.class).withGeneratedName();
        ConfigurationModule.bindConfig((Binder)binder).to(QueryManagerConfig.class);
        binder.bind(NativeSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(NativeDataStreamProvider.class).in(Scopes.SINGLETON);
        binder.bind(SplitManager.class).in(Scopes.SINGLETON);
        binder.bind(NodeManager.class).to(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(NodeSchedulerConfig.class);
        binder.bind(NodeScheduler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NodeScheduler.class).withGeneratedName();
        binder.bind(ShardManager.class).to(DatabaseShardManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(ShardCleanerConfig.class);
        binder.bind(ShardCleaner.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("shard-cleaner", ForShardCleaner.class);
        binder.bind(ShardResource.class).in(Scopes.SINGLETON);
        binder.bind(StorageManager.class).to(DatabaseStorageManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(PeriodicImportConfig.class);
        binder.bind(PeriodicImportJobResource.class).in(Scopes.SINGLETON);
        binder.bind(PeriodicImportManager.class).to(DatabasePeriodicImportManager.class).in(Scopes.SINGLETON);
        binder.bind(PeriodicImportController.class).in(Scopes.SINGLETON);
        binder.bind(JobStateFactory.class).in(Scopes.SINGLETON);
        binder.bind(PeriodicImportRunnable.PeriodicImportRunnableFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PeriodicImportController.class).as("com.facebook.presto:name=periodic-import");
        HttpClientBinder.httpClientBinder((Binder)binder).bindAsyncHttpClient("periodic-importer", ForPeriodicImport.class).withTracing();
        binder.bind(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SqlQueryExecution.SqlQueryExecutionFactory.class).withGeneratedName();
        MapBinder executionBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<QueryExecution.QueryExecutionFactory<?>>(){});
        binder.bind(DropTableExecution.DropTableExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(DropTable.class).to(DropTableExecution.DropTableExecutionFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DropTableExecution.DropTableExecutionFactory.class).withGeneratedName();
        binder.bind(CreateAliasExecution.CreateAliasExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(CreateAlias.class).to(CreateAliasExecution.CreateAliasExecutionFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(CreateAliasExecution.CreateAliasExecutionFactory.class).withGeneratedName();
        binder.bind(DropAliasExecution.DropAliasExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(DropAlias.class).to(DropAliasExecution.DropAliasExecutionFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DropAliasExecution.DropAliasExecutionFactory.class).withGeneratedName();
        executionBinder.addBinding(Query.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(Explain.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowColumns.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowPartitions.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowFunctions.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowTables.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(ShowSchemas.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(CreateMaterializedView.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        executionBinder.addBinding(RefreshMaterializedView.class).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public AliasDao createAliasDao(@ForMetadata IDBI dbi) throws InterruptedException {
        Preconditions.checkNotNull((Object)dbi, (Object)"dbi is null");
        AliasDao aliasDao = (AliasDao)dbi.onDemand(AliasDao.class);
        AliasDao.Utils.createTablesWithRetry((AliasDao)aliasDao);
        return aliasDao;
    }
}

