/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.reloading;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.resourceGroups.AbstractResourceConfigurationManager;
import com.facebook.presto.resourceGroups.ManagerSpec;
import com.facebook.presto.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.resourceGroups.reloading.ManagerSpecProvider;
import com.facebook.presto.resourceGroups.reloading.ReloadingResourceGroupConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ReloadingResourceGroupConfigurationManager
extends AbstractResourceConfigurationManager {
    private static final Logger log = Logger.get(ReloadingResourceGroupConfigurationManager.class);
    private final ConcurrentMap<ResourceGroupId, ResourceGroup> groups = new ConcurrentHashMap<ResourceGroupId, ResourceGroup>();
    @GuardedBy(value="this")
    private Map<ResourceGroupIdTemplate, ResourceGroupSpec> resourceGroupSpecs = new HashMap<ResourceGroupIdTemplate, ResourceGroupSpec>();
    private final ConcurrentMap<ResourceGroupIdTemplate, List<ResourceGroupId>> configuredGroups = new ConcurrentHashMap<ResourceGroupIdTemplate, List<ResourceGroupId>>();
    private final AtomicReference<List<ResourceGroupSpec>> rootGroups = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<List<ResourceGroupSelector>> selectors = new AtomicReference();
    private final AtomicReference<Optional<Duration>> cpuQuotaPeriod = new AtomicReference(Optional.empty());
    private final ManagerSpecProvider managerSpecProvider;
    private final ScheduledExecutorService configExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"DbResourceGroupConfigurationManager"));
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicLong lastRefresh = new AtomicLong();
    private final Duration maxRefreshInterval;
    private final boolean exactMatchSelectorEnabled;
    private final CounterStat refreshFailures = new CounterStat();

    @Inject
    public ReloadingResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, ReloadingResourceGroupConfig config, ManagerSpecProvider managerSpecProvider) {
        super(memoryPoolManager);
        Objects.requireNonNull(memoryPoolManager, "memoryPoolManager is null");
        this.maxRefreshInterval = config.getMaxRefreshInterval();
        this.exactMatchSelectorEnabled = config.getExactMatchSelectorEnabled();
        this.managerSpecProvider = Objects.requireNonNull(managerSpecProvider, "provider is null");
        this.load();
    }

    @Override
    protected Optional<Duration> getCpuQuotaPeriod() {
        return this.cpuQuotaPeriod.get();
    }

    @Override
    protected List<ResourceGroupSpec> getRootGroups() {
        this.checkMaxRefreshInterval();
        if (this.selectors.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "No root groups are configured");
        }
        return this.rootGroups.get();
    }

    @PreDestroy
    public void destroy() {
        this.configExecutor.shutdownNow();
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.configExecutor.scheduleWithFixedDelay(this::load, 10L, 10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ResourceGroup group, SelectionContext<VariableMap> criteria) {
        Map.Entry<ResourceGroupIdTemplate, ResourceGroupSpec> entry = this.getMatchingSpec(group, criteria);
        if (this.groups.putIfAbsent(group.getId(), group) == null) {
            this.configuredGroups.computeIfAbsent(entry.getKey(), v -> new LinkedList()).add(group.getId());
        }
        ResourceGroup resourceGroup = this.getRootGroup(group.getId());
        synchronized (resourceGroup) {
            this.configureGroup(group, entry.getValue());
        }
    }

    public Optional<SelectionContext<VariableMap>> match(SelectionCriteria criteria) {
        this.checkMaxRefreshInterval();
        if (this.selectors.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "No selectors are configured");
        }
        return this.selectors.get().stream().map(s -> s.match(criteria)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @VisibleForTesting
    public List<ResourceGroupSelector> getSelectors() {
        this.checkMaxRefreshInterval();
        if (this.selectors.get().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "No selectors are configured");
        }
        return this.selectors.get();
    }

    @VisibleForTesting
    public synchronized void load() {
        block8: {
            try {
                ManagerSpec managerSpec = this.managerSpecProvider.getManagerSpec();
                this.validateRootGroups(managerSpec);
                List<ResourceGroupSpec> rootGroups = managerSpec.getRootGroups();
                HashMap<ResourceGroupIdTemplate, ResourceGroupSpec> resourceGroupSpecs = new HashMap<ResourceGroupIdTemplate, ResourceGroupSpec>();
                this.buildResourceGroupSpecsMap(resourceGroupSpecs, rootGroups, Optional.empty());
                HashSet<ResourceGroupIdTemplate> changedSpecs = new HashSet<ResourceGroupIdTemplate>();
                Sets.SetView deletedSpecs = Sets.difference(this.resourceGroupSpecs.keySet(), resourceGroupSpecs.keySet());
                for (Map.Entry entry : resourceGroupSpecs.entrySet()) {
                    if (((ResourceGroupSpec)entry.getValue()).sameConfig(this.resourceGroupSpecs.get(entry.getKey()))) continue;
                    changedSpecs.add((ResourceGroupIdTemplate)entry.getKey());
                }
                this.resourceGroupSpecs = resourceGroupSpecs;
                this.cpuQuotaPeriod.set(managerSpec.getCpuQuotaPeriod());
                this.rootGroups.set(managerSpec.getRootGroups());
                ImmutableList.Builder selectorsBuilder = ImmutableList.builder();
                if (this.exactMatchSelectorEnabled) {
                    selectorsBuilder.addAll(this.managerSpecProvider.getExactMatchSelectors());
                }
                selectorsBuilder.addAll(this.buildSelectors(managerSpec));
                this.selectors.set((List<ResourceGroupSelector>)selectorsBuilder.build());
                this.configureChangedGroups(changedSpecs);
                this.disableDeletedGroups((Set<ResourceGroupIdTemplate>)deletedSpecs);
                if (this.lastRefresh.get() > 0L) {
                    for (ResourceGroupIdTemplate deleted : deletedSpecs) {
                        log.info("Resource group spec deleted %s", new Object[]{deleted});
                    }
                    for (ResourceGroupIdTemplate changed : changedSpecs) {
                        log.info("Resource group spec %s changed to %s", new Object[]{changed, resourceGroupSpecs.get(changed)});
                    }
                } else {
                    log.info("Loaded %s selectors and %s resource groups from source", new Object[]{this.selectors.get().size(), this.resourceGroupSpecs.size()});
                }
                this.lastRefresh.set(System.nanoTime());
            }
            catch (Throwable e) {
                this.refreshFailures.update(1L);
                log.error(e, "Error loading configuration from source");
                if (this.lastRefresh.get() == 0L) break block8;
                log.debug("Last successful configuration loading was %s ago", new Object[]{Duration.succinctNanos((long)(System.nanoTime() - this.lastRefresh.get())).toString()});
            }
        }
    }

    private synchronized void buildResourceGroupSpecsMap(Map<ResourceGroupIdTemplate, ResourceGroupSpec> resourceGroupSpecs, List<ResourceGroupSpec> childResourceGroups, Optional<ResourceGroupIdTemplate> parentId) {
        for (ResourceGroupSpec resourceGroupSpec : childResourceGroups) {
            ResourceGroupIdTemplate childId = parentId.isPresent() ? ResourceGroupIdTemplate.forSubGroupNamed(parentId.get(), resourceGroupSpec.getName().toString()) : new ResourceGroupIdTemplate(resourceGroupSpec.getName().toString());
            if (!resourceGroupSpec.getSubGroups().isEmpty()) {
                this.buildResourceGroupSpecsMap(resourceGroupSpecs, resourceGroupSpec.getSubGroups(), Optional.of(childId));
            }
            resourceGroupSpecs.put(childId, resourceGroupSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void configureChangedGroups(Set<ResourceGroupIdTemplate> changedSpecs) {
        for (ResourceGroupIdTemplate resourceGroupIdTemplate : changedSpecs) {
            for (ResourceGroupId resourceGroupId : this.configuredGroups.getOrDefault(resourceGroupIdTemplate, (List<ResourceGroupId>)ImmutableList.of())) {
                ResourceGroup resourceGroup = this.getRootGroup(resourceGroupId);
                synchronized (resourceGroup) {
                    this.configureGroup((ResourceGroup)this.groups.get(resourceGroupId), this.resourceGroupSpecs.get(resourceGroupIdTemplate));
                }
            }
        }
    }

    private synchronized void disableDeletedGroups(Set<ResourceGroupIdTemplate> deletedSpecs) {
        for (ResourceGroupIdTemplate resourceGroupIdTemplate : deletedSpecs) {
            for (ResourceGroupId resourceGroupId : this.configuredGroups.getOrDefault(resourceGroupIdTemplate, (List<ResourceGroupId>)ImmutableList.of())) {
                this.disableGroup((ResourceGroup)this.groups.get(resourceGroupId));
            }
        }
    }

    private synchronized void disableGroup(ResourceGroup group) {
        group.setHardConcurrencyLimit(0);
        group.setMaxQueuedQueries(0);
    }

    private ResourceGroup getRootGroup(ResourceGroupId groupId) {
        ResourceGroupId current = groupId;
        Optional parent = current.getParent();
        while (parent.isPresent()) {
            current = (ResourceGroupId)parent.get();
            parent = current.getParent();
        }
        ResourceGroup rootResourceGroup = (ResourceGroup)this.groups.get(current);
        Preconditions.checkState((rootResourceGroup != null ? 1 : 0) != 0, (String)"%s is missing in the groups map for groupId %s", (Object)current, (Object)groupId);
        return rootResourceGroup;
    }

    private void checkMaxRefreshInterval() {
        if (System.nanoTime() - this.lastRefresh.get() > this.maxRefreshInterval.toMillis() * TimeUnit.MILLISECONDS.toNanos(1L)) {
            String message = "Resource group configuration cannot be fetched from source.";
            if (this.lastRefresh.get() != 0L) {
                message = message + String.format(" Current resource group configuration is loaded %s ago", Duration.succinctNanos((long)(System.nanoTime() - this.lastRefresh.get())).toString());
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_UNAVAILABLE, message);
        }
    }

    @Managed
    @Nested
    public CounterStat getRefreshFailures() {
        return this.refreshFailures;
    }
}

