/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.resourceGroups.SelectorResourceEstimate;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class SelectorRecord {
    private final long resourceGroupId;
    private final long priority;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> sourceRegex;
    private final Optional<String> queryType;
    private final Optional<List<String>> clientTags;
    private final Optional<SelectorResourceEstimate> selectorResourceEstimate;
    private final Optional<Pattern> clientInfoRegex;
    private final Optional<String> schema;
    private final Optional<Pattern> principalRegex;

    public SelectorRecord(long resourceGroupId, long priority, Optional<Pattern> userRegex, Optional<Pattern> sourceRegex, Optional<String> queryType, Optional<List<String>> clientTags, Optional<SelectorResourceEstimate> selectorResourceEstimate, Optional<Pattern> clientInfoRegex, Optional<String> schema, Optional<Pattern> principalRegex) {
        this.resourceGroupId = resourceGroupId;
        this.priority = priority;
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null").map(ImmutableList::copyOf);
        this.selectorResourceEstimate = Objects.requireNonNull(selectorResourceEstimate, "selectorResourceEstimate is null");
        this.clientInfoRegex = Objects.requireNonNull(clientInfoRegex, "clientInfoRegex is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.principalRegex = Objects.requireNonNull(principalRegex, "principalRegex is null");
    }

    public long getResourceGroupId() {
        return this.resourceGroupId;
    }

    public long getPriority() {
        return this.priority;
    }

    public Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    public Optional<Pattern> getSourceRegex() {
        return this.sourceRegex;
    }

    public Optional<String> getQueryType() {
        return this.queryType;
    }

    public Optional<List<String>> getClientTags() {
        return this.clientTags;
    }

    public Optional<SelectorResourceEstimate> getSelectorResourceEstimate() {
        return this.selectorResourceEstimate;
    }

    public Optional<Pattern> getClientInfoRegex() {
        return this.clientInfoRegex;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<Pattern> getPrincipalRegex() {
        return this.principalRegex;
    }

    public static class Mapper
    implements RowMapper<SelectorRecord> {
        private static final JsonCodec<List<String>> LIST_STRING_CODEC = JsonCodec.listJsonCodec(String.class);
        private static final JsonCodec<SelectorResourceEstimate> SELECTOR_RESOURCE_ESTIMATE_JSON_CODEC = JsonCodec.jsonCodec(SelectorResourceEstimate.class);

        public SelectorRecord map(ResultSet resultSet, StatementContext context) throws SQLException {
            return new SelectorRecord(resultSet.getLong("resource_group_id"), resultSet.getLong("priority"), Optional.ofNullable(resultSet.getString("user_regex")).map(Pattern::compile), Optional.ofNullable(resultSet.getString("source_regex")).map(Pattern::compile), Optional.ofNullable(resultSet.getString("query_type")), Optional.ofNullable(resultSet.getString("client_tags")).map(arg_0 -> LIST_STRING_CODEC.fromJson(arg_0)), Optional.ofNullable(resultSet.getString("selector_resource_estimate")).map(arg_0 -> SELECTOR_RESOURCE_ESTIMATE_JSON_CODEC.fromJson(arg_0)), Optional.ofNullable(resultSet.getString("client_info_regex")).map(Pattern::compile), Optional.ofNullable(resultSet.getString("schema")), Optional.ofNullable(resultSet.getString("principal_regex")).map(Pattern::compile));
        }
    }
}

