/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.presto.resourceGroups.ManagerSpec;
import com.facebook.presto.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.SelectorSpec;
import com.facebook.presto.resourceGroups.db.DbSourceExactMatchSelector;
import com.facebook.presto.resourceGroups.db.ForEnvironment;
import com.facebook.presto.resourceGroups.db.ResourceGroupGlobalProperties;
import com.facebook.presto.resourceGroups.db.ResourceGroupSpecBuilder;
import com.facebook.presto.resourceGroups.db.ResourceGroupsDao;
import com.facebook.presto.resourceGroups.reloading.ManagerSpecProvider;
import com.facebook.presto.resourceGroups.reloading.ReloadingResourceGroupConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DbManagerSpecProvider
implements ManagerSpecProvider {
    private final ResourceGroupsDao resourceGroupsDao;
    private final String environment;

    @Inject
    public DbManagerSpecProvider(ResourceGroupsDao dao, @ForEnvironment String environment, ReloadingResourceGroupConfig config) {
        this.resourceGroupsDao = Objects.requireNonNull(dao, "dao is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.resourceGroupsDao.createResourceGroupsGlobalPropertiesTable();
        this.resourceGroupsDao.createResourceGroupsTable();
        this.resourceGroupsDao.createSelectorsTable();
        if (config.getExactMatchSelectorEnabled()) {
            this.resourceGroupsDao.createExactMatchSelectorsTable();
        }
    }

    @Override
    public synchronized ManagerSpec getManagerSpec() {
        HashSet<Long> rootGroupIds = new HashSet<Long>();
        HashMap<Long, ResourceGroupSpec> resourceGroupSpecMap = new HashMap<Long, ResourceGroupSpec>();
        HashMap<Long, ResourceGroupIdTemplate> resourceGroupIdTemplateMap = new HashMap<Long, ResourceGroupIdTemplate>();
        HashMap<Long, ResourceGroupSpecBuilder> recordMap = new HashMap<Long, ResourceGroupSpecBuilder>();
        HashMap<Long, Set<Long>> subGroupIdsToBuild = new HashMap<Long, Set<Long>>();
        this.populateFromDbHelper(recordMap, rootGroupIds, resourceGroupIdTemplateMap, subGroupIdsToBuild);
        LinkedList<Long> queue = new LinkedList<Long>(rootGroupIds);
        while (!queue.isEmpty()) {
            Long id = queue.pollFirst();
            resourceGroupIdTemplateMap.computeIfAbsent(id, k -> {
                ResourceGroupSpecBuilder builder = (ResourceGroupSpecBuilder)recordMap.get(k);
                return ResourceGroupIdTemplate.forSubGroupNamed((ResourceGroupIdTemplate)resourceGroupIdTemplateMap.get(builder.getParentId().get()), builder.getNameTemplate().toString());
            });
            Set<Long> childrenToBuild = subGroupIdsToBuild.getOrDefault(id, (Set<Long>)ImmutableSet.of());
            if (childrenToBuild.isEmpty()) {
                ResourceGroupSpecBuilder builder = (ResourceGroupSpecBuilder)recordMap.get(id);
                ResourceGroupSpec resourceGroupSpec = builder.build();
                resourceGroupSpecMap.put(id, resourceGroupSpec);
                builder.getParentId().ifPresent(parentId -> {
                    ((ResourceGroupSpecBuilder)recordMap.get(parentId)).addSubGroup(resourceGroupSpec);
                    ((Set)subGroupIdsToBuild.get(parentId)).remove(id);
                });
                continue;
            }
            queue.addFirst(id);
            queue.addAll(0, childrenToBuild);
        }
        List<ResourceGroupSpec> rootGroups = rootGroupIds.stream().map(resourceGroupSpecMap::get).collect(Collectors.toList());
        List<SelectorSpec> selectors = this.resourceGroupsDao.getSelectors(this.environment).stream().map(selectorRecord -> new SelectorSpec(selectorRecord.getUserRegex(), selectorRecord.getSourceRegex(), selectorRecord.getQueryType(), selectorRecord.getClientTags(), selectorRecord.getSelectorResourceEstimate(), (ResourceGroupIdTemplate)resourceGroupIdTemplateMap.get(selectorRecord.getResourceGroupId()))).collect(Collectors.toList());
        ManagerSpec managerSpec = new ManagerSpec(rootGroups, selectors, this.getCpuQuotaPeriodFromDb());
        return managerSpec;
    }

    private synchronized void populateFromDbHelper(Map<Long, ResourceGroupSpecBuilder> recordMap, Set<Long> rootGroupIds, Map<Long, ResourceGroupIdTemplate> resourceGroupIdTemplateMap, Map<Long, Set<Long>> subGroupIdsToBuild) {
        List<ResourceGroupSpecBuilder> records = this.resourceGroupsDao.getResourceGroups(this.environment);
        for (ResourceGroupSpecBuilder record : records) {
            recordMap.put(record.getId(), record);
            if (!record.getParentId().isPresent()) {
                rootGroupIds.add(record.getId());
                resourceGroupIdTemplateMap.put(record.getId(), new ResourceGroupIdTemplate(record.getNameTemplate().toString()));
                continue;
            }
            subGroupIdsToBuild.computeIfAbsent(record.getParentId().get(), k -> new HashSet()).add(record.getId());
        }
    }

    private synchronized Optional<Duration> getCpuQuotaPeriodFromDb() {
        List<ResourceGroupGlobalProperties> globalProperties = this.resourceGroupsDao.getResourceGroupGlobalProperties();
        Preconditions.checkState((globalProperties.size() <= 1 ? 1 : 0) != 0, (Object)"There is more than one cpu_quota_period");
        return !globalProperties.isEmpty() ? globalProperties.get(0).getCpuQuotaPeriod() : Optional.empty();
    }

    @Override
    public List<ResourceGroupSelector> getExactMatchSelectors() {
        return ImmutableList.of((Object)new DbSourceExactMatchSelector(this.environment, this.resourceGroupsDao));
    }
}

