/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.resourceGroups.AbstractResourceConfigurationManager;
import com.facebook.presto.resourceGroups.FileResourceGroupConfig;
import com.facebook.presto.resourceGroups.ManagerSpec;
import com.facebook.presto.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.units.Duration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class FileResourceGroupConfigurationManager
extends AbstractResourceConfigurationManager {
    private static final JsonCodec<ManagerSpec> CODEC = new JsonCodecFactory(() -> new JsonObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).jsonCodec(ManagerSpec.class);
    private final List<ResourceGroupSpec> rootGroups;
    private final List<ResourceGroupSelector> selectors;
    private final Optional<Duration> cpuQuotaPeriod;

    @Inject
    public FileResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, FileResourceGroupConfig config) {
        super(memoryPoolManager);
        ManagerSpec managerSpec;
        Objects.requireNonNull(config, "config is null");
        try {
            managerSpec = (ManagerSpec)CODEC.fromJson(Files.readAllBytes(Paths.get(config.getConfigFile(), new String[0])));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnrecognizedPropertyException) {
                UnrecognizedPropertyException ex = (UnrecognizedPropertyException)cause;
                String message = String.format("Unknown property at line %s:%s: %s", ex.getLocation().getLineNr(), ex.getLocation().getColumnNr(), ex.getPropertyName());
                throw new IllegalArgumentException(message, e);
            }
            if (cause instanceof JsonMappingException) {
                if (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                throw new IllegalArgumentException(cause.getMessage(), e);
            }
            throw e;
        }
        this.rootGroups = managerSpec.getRootGroups();
        this.cpuQuotaPeriod = managerSpec.getCpuQuotaPeriod();
        this.validateRootGroups(managerSpec);
        this.selectors = this.buildSelectors(managerSpec);
    }

    @Override
    protected Optional<Duration> getCpuQuotaPeriod() {
        return this.cpuQuotaPeriod;
    }

    @Override
    protected List<ResourceGroupSpec> getRootGroups() {
        return this.rootGroups;
    }

    public void configure(ResourceGroup group, SelectionContext<VariableMap> context) {
        Map.Entry<ResourceGroupIdTemplate, ResourceGroupSpec> entry = this.getMatchingSpec(group, context);
        this.configureGroup(group, entry.getValue());
    }

    public Optional<SelectionContext<VariableMap>> match(SelectionCriteria criteria) {
        return this.selectors.stream().map(s -> s.match(criteria)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @VisibleForTesting
    public List<ResourceGroupSelector> getSelectors() {
        return this.selectors;
    }
}

