/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.presto.resourceGroups.db.DbResourceGroupConfig;
import com.facebook.presto.resourceGroups.db.ResourceGroupsDao;
import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class MysqlDaoProvider
implements Provider<ResourceGroupsDao> {
    private final ResourceGroupsDao dao;

    @Inject
    public MysqlDaoProvider(DbResourceGroupConfig config) {
        Objects.requireNonNull(config, "DbResourceGroupConfig is null");
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setURL(Objects.requireNonNull(config.getConfigDbUrl(), "resource-groups.config-db-url is null"));
        this.dao = (ResourceGroupsDao)Jdbi.create((DataSource)dataSource).installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(ResourceGroupsDao.class);
    }

    public ResourceGroupsDao get() {
        return this.dao;
    }
}

