/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups.db;

import com.facebook.presto.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.resourceGroups.VariableMap;
import com.facebook.presto.resourceGroups.db.ResourceGroupsDao;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.jdbi.v3.core.JdbiException;

public class DbSourceExactMatchSelector
implements ResourceGroupSelector {
    private static final Logger log = Logger.get(DbSourceExactMatchSelector.class);
    private static final JsonCodec<ResourceGroupId> resourceGroupIdCodec = JsonCodec.jsonCodec(ResourceGroupId.class);
    private final ResourceGroupsDao dao;
    private final String environment;
    private final AtomicReference<Long> daoOfflineStart = new AtomicReference();

    public DbSourceExactMatchSelector(String environment, ResourceGroupsDao dao) {
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.dao = Objects.requireNonNull(dao, "dao is null");
    }

    @Override
    public Optional<SelectionContext<VariableMap>> match(SelectionCriteria criteria) {
        if (!criteria.getSource().isPresent()) {
            return Optional.empty();
        }
        try {
            String resourceGroupId = this.dao.getExactMatchResourceGroup(this.environment, (String)criteria.getSource().get(), criteria.getQueryType().orElse(""));
            Long start = this.daoOfflineStart.get();
            if (start != null && this.daoOfflineStart.compareAndSet(start, null)) {
                log.info("Successfully fetched exact match selectors after %s", new Object[]{Duration.nanosSince((long)start)});
            }
            if (resourceGroupId == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(new SelectionContext((ResourceGroupId)resourceGroupIdCodec.fromJson(resourceGroupId), (Object)VariableMap.emptyVariableMap()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to decode resource group from DB: %s", new Object[]{resourceGroupId});
                return Optional.empty();
            }
        }
        catch (JdbiException e) {
            if (this.daoOfflineStart.compareAndSet(null, System.nanoTime())) {
                log.warn((Throwable)e, "Failed to fetch exact match resource group selectors");
            }
            return Optional.empty();
        }
    }
}

