/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class StaticSelector
implements ResourceGroupSelector {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> sourceRegex;
    private final ResourceGroupIdTemplate group;

    public StaticSelector(Optional<Pattern> userRegex, Optional<Pattern> sourceRegex, ResourceGroupIdTemplate group) {
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        this.group = Objects.requireNonNull(group, "group is null");
    }

    public Optional<ResourceGroupId> match(SelectionContext context) {
        if (this.userRegex.isPresent() && !this.userRegex.get().matcher(context.getUser()).matches()) {
            return Optional.empty();
        }
        if (this.sourceRegex.isPresent()) {
            String source = context.getSource().orElse("");
            if (!this.sourceRegex.get().matcher(source).matches()) {
                return Optional.empty();
            }
        }
        return Optional.of(this.group.expandTemplate(context));
    }
}

