/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceGroupSpec {
    private static final Pattern PERCENT_PATTERN = Pattern.compile("(\\d{1,3}(:?\\.\\d+)?)%");
    private final ResourceGroupNameTemplate name;
    private final Optional<DataSize> softMemoryLimit;
    private final Optional<Double> softMemoryLimitFraction;
    private final int maxQueued;
    private final int maxRunning;
    private final Optional<SchedulingPolicy> schedulingPolicy;
    private final Optional<Integer> schedulingWeight;
    private final List<ResourceGroupSpec> subGroups;
    private final Optional<Boolean> jmxExport;
    private final Optional<Duration> softCpuLimit;
    private final Optional<Duration> hardCpuLimit;

    @JsonCreator
    public ResourceGroupSpec(@JsonProperty(value="name") ResourceGroupNameTemplate name, @JsonProperty(value="softMemoryLimit") String softMemoryLimit, @JsonProperty(value="maxQueued") int maxQueued, @JsonProperty(value="maxRunning") int maxRunning, @JsonProperty(value="schedulingPolicy") Optional<String> schedulingPolicy, @JsonProperty(value="schedulingWeight") Optional<Integer> schedulingWeight, @JsonProperty(value="subGroups") Optional<List<ResourceGroupSpec>> subGroups, @JsonProperty(value="jmxExport") Optional<Boolean> jmxExport, @JsonProperty(value="softCpuLimit") Optional<Duration> softCpuLimit, @JsonProperty(value="hardCpuLimit") Optional<Duration> hardCpuLimit) {
        Optional<Object> fraction;
        Optional<Object> absoluteSize;
        this.softCpuLimit = Objects.requireNonNull(softCpuLimit, "softCpuLimit is null");
        this.hardCpuLimit = Objects.requireNonNull(hardCpuLimit, "hardCpuLimit is null");
        this.jmxExport = Objects.requireNonNull(jmxExport, "jmxExport is null");
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((maxQueued >= 0 ? 1 : 0) != 0, (Object)"maxQueued is negative");
        this.maxQueued = maxQueued;
        Preconditions.checkArgument((maxRunning >= 0 ? 1 : 0) != 0, (Object)"maxRunning is negative");
        this.maxRunning = maxRunning;
        this.schedulingPolicy = Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null").map(value -> SchedulingPolicy.valueOf((String)value.toUpperCase()));
        this.schedulingWeight = Objects.requireNonNull(schedulingWeight, "schedulingWeight is null");
        Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        Matcher matcher = PERCENT_PATTERN.matcher(softMemoryLimit);
        if (matcher.matches()) {
            absoluteSize = Optional.empty();
            fraction = Optional.of(Double.parseDouble(matcher.group(1)) / 100.0);
        } else {
            absoluteSize = Optional.of(DataSize.valueOf((String)softMemoryLimit));
            fraction = Optional.empty();
        }
        this.softMemoryLimit = absoluteSize;
        this.softMemoryLimitFraction = fraction;
        this.subGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(subGroups, "subGroups is null").orElse((List<ResourceGroupSpec>)ImmutableList.of()));
        HashSet<ResourceGroupNameTemplate> names = new HashSet<ResourceGroupNameTemplate>();
        for (ResourceGroupSpec subGroup : this.subGroups) {
            Preconditions.checkArgument((!names.contains(subGroup.getName()) ? 1 : 0) != 0, (String)"Duplicated sub group: %s", (Object[])new Object[]{subGroup.getName()});
            names.add(subGroup.getName());
        }
    }

    public Optional<DataSize> getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    public Optional<Double> getSoftMemoryLimitFraction() {
        return this.softMemoryLimitFraction;
    }

    public int getMaxQueued() {
        return this.maxQueued;
    }

    public int getMaxRunning() {
        return this.maxRunning;
    }

    public Optional<SchedulingPolicy> getSchedulingPolicy() {
        return this.schedulingPolicy;
    }

    public Optional<Integer> getSchedulingWeight() {
        return this.schedulingWeight;
    }

    public ResourceGroupNameTemplate getName() {
        return this.name;
    }

    public List<ResourceGroupSpec> getSubGroups() {
        return this.subGroups;
    }

    public Optional<Boolean> getJmxExport() {
        return this.jmxExport;
    }

    public Optional<Duration> getSoftCpuLimit() {
        return this.softCpuLimit;
    }

    public Optional<Duration> getHardCpuLimit() {
        return this.hardCpuLimit;
    }
}

