/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceGroupNameTemplate {
    private static final Pattern USER_PATTERN = Pattern.compile(Pattern.quote("${USER}"));
    private static final Pattern SOURCE_PATTERN = Pattern.compile(Pattern.quote("${SOURCE}"));
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private final String name;

    @JsonCreator
    public ResourceGroupNameTemplate(String name) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Resource group name is empty");
        Preconditions.checkArgument((name.indexOf(46) < 0 ? 1 : 0) != 0, (String)"Invalid resource group name. '%s' contains a '.'", (Object[])new Object[]{name});
        Matcher matcher = PARAMETER_PATTERN.matcher(name);
        while (matcher.find()) {
            String group = matcher.group(1);
            Preconditions.checkArgument((group.equals("USER") || group.equals("SOURCE") ? 1 : 0) != 0, (String)"Unsupported template parameter: ${%s}", (Object[])new Object[]{group});
        }
    }

    public String expandTemplate(SelectionContext context) {
        String expanded = USER_PATTERN.matcher(this.name).replaceAll(context.getUser());
        return SOURCE_PATTERN.matcher(expanded).replaceAll(context.getSource().orElse(""));
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupNameTemplate that = (ResourceGroupNameTemplate)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

