/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourceGroups;

import com.facebook.presto.resourceGroups.FileResourceGroupConfig;
import com.facebook.presto.resourceGroups.ManagerSpec;
import com.facebook.presto.resourceGroups.ResourceGroupSpec;
import com.facebook.presto.resourceGroups.SelectorSpec;
import com.facebook.presto.resourceGroups.StaticSelector;
import com.facebook.presto.spi.memory.ClusterMemoryPoolManager;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.ResourceGroup;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.spi.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public class FileResourceGroupConfigurationManager
implements ResourceGroupConfigurationManager {
    private final List<ResourceGroupSpec> rootGroups;
    private final List<ResourceGroupSelector> selectors;
    private final Optional<Duration> cpuQuotaPeriodMillis;
    @GuardedBy(value="generalPoolMemoryFraction")
    private final Map<ResourceGroup, Double> generalPoolMemoryFraction = new HashMap<ResourceGroup, Double>();
    @GuardedBy(value="generalPoolMemoryFraction")
    private long generalPoolBytes;

    @Inject
    public FileResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, FileResourceGroupConfig config, JsonCodec<ManagerSpec> codec) {
        ManagerSpec managerSpec;
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(codec, "codec is null");
        try {
            managerSpec = (ManagerSpec)codec.fromJson(Files.readAllBytes(Paths.get(config.getConfigFile(), new String[0])));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.rootGroups = managerSpec.getRootGroups();
        this.cpuQuotaPeriodMillis = managerSpec.getCpuQuotaPeriod();
        LinkedList<ResourceGroupSpec> groups = new LinkedList<ResourceGroupSpec>(this.rootGroups);
        while (!groups.isEmpty()) {
            ResourceGroupSpec group = (ResourceGroupSpec)groups.poll();
            groups.addAll(group.getSubGroups());
            if (group.getSoftCpuLimit().isPresent() || group.getHardCpuLimit().isPresent()) {
                Preconditions.checkArgument((boolean)managerSpec.getCpuQuotaPeriod().isPresent(), (String)"cpuQuotaPeriod must be specified to use cpu limits on group: %s", (Object[])new Object[]{group.getName()});
            }
            if (!group.getSoftCpuLimit().isPresent()) continue;
            Preconditions.checkArgument((boolean)group.getHardCpuLimit().isPresent(), (Object)"Must specify hard CPU limit in addition to soft limit");
            Preconditions.checkArgument((group.getSoftCpuLimit().get().compareTo(group.getHardCpuLimit().get()) <= 0 ? 1 : 0) != 0, (Object)"Soft CPU limit cannot be greater than hard CPU limit");
        }
        ImmutableList.Builder selectors = ImmutableList.builder();
        for (SelectorSpec spec : managerSpec.getSelectors()) {
            selectors.add((Object)new StaticSelector(spec.getUserRegex(), spec.getSourceRegex(), spec.getGroup()));
        }
        this.selectors = selectors.build();
        memoryPoolManager.addChangeListener(new MemoryPoolId("general"), poolInfo -> {
            Map<ResourceGroup, Double> map = this.generalPoolMemoryFraction;
            synchronized (map) {
                for (Map.Entry<ResourceGroup, Double> entry : this.generalPoolMemoryFraction.entrySet()) {
                    double bytes = (double)poolInfo.getMaxBytes() * entry.getValue();
                    entry.getKey().setSoftMemoryLimit(new DataSize(bytes, DataSize.Unit.BYTE));
                }
                this.generalPoolBytes = poolInfo.getMaxBytes();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ResourceGroup group, SelectionContext context) {
        List<ResourceGroupSpec> candidates = this.rootGroups;
        List segments = group.getId().getSegments();
        ResourceGroupSpec match = null;
        for (int i = 0; i < segments.size(); ++i) {
            List<ResourceGroupSpec> nextCandidates = null;
            ResourceGroupSpec nextCandidatesParent = null;
            for (ResourceGroupSpec candidate : candidates) {
                if (!candidate.getName().expandTemplate(context).equals(segments.get(i))) continue;
                if (i == segments.size() - 1) {
                    if (match != null) {
                        throw new IllegalStateException(String.format("Ambiguous configuration for %s. Matches %s and %s", group.getId(), match.getName(), candidate.getName()));
                    }
                    match = candidate;
                    continue;
                }
                if (nextCandidatesParent != null) {
                    throw new IllegalStateException(String.format("Ambiguous configuration for %s. Matches %s and %s", group.getId(), nextCandidatesParent.getName(), candidate.getName()));
                }
                nextCandidates = candidate.getSubGroups();
                nextCandidatesParent = candidate;
            }
            if (nextCandidates == null) break;
            candidates = nextCandidates;
        }
        Preconditions.checkState((match != null ? 1 : 0) != 0, (String)"No matching configuration found for: %s", (Object[])new Object[]{group.getId()});
        if (match.getSoftMemoryLimit().isPresent()) {
            group.setSoftMemoryLimit(match.getSoftMemoryLimit().get());
        } else {
            Map<ResourceGroup, Double> i = this.generalPoolMemoryFraction;
            synchronized (i) {
                double fraction = match.getSoftMemoryLimitFraction().get();
                this.generalPoolMemoryFraction.put(group, fraction);
                group.setSoftMemoryLimit(new DataSize((double)this.generalPoolBytes * fraction, DataSize.Unit.BYTE));
            }
        }
        group.setMaxQueuedQueries(match.getMaxQueued());
        group.setMaxRunningQueries(match.getMaxRunning());
        if (match.getSchedulingPolicy().isPresent()) {
            group.setSchedulingPolicy(match.getSchedulingPolicy().get());
        }
        if (match.getSchedulingWeight().isPresent()) {
            group.setSchedulingWeight(match.getSchedulingWeight().get().intValue());
        }
        if (match.getJmxExport().isPresent()) {
            group.setJmxExport(match.getJmxExport().get().booleanValue());
        }
        if (match.getSoftCpuLimit().isPresent() || match.getHardCpuLimit().isPresent()) {
            Preconditions.checkState((boolean)this.cpuQuotaPeriodMillis.isPresent());
            Duration limit = match.getHardCpuLimit().isPresent() ? match.getHardCpuLimit().get() : match.getSoftCpuLimit().get();
            long rate = (long)Math.min(1000.0 * (double)limit.toMillis() / (double)this.cpuQuotaPeriodMillis.get().toMillis(), 9.223372036854776E18);
            rate = Math.max(1L, rate);
            group.setCpuQuotaGenerationMillisPerSecond(rate);
        }
        if (match.getSoftCpuLimit().isPresent()) {
            group.setSoftCpuLimit(match.getSoftCpuLimit().get());
        }
        if (match.getHardCpuLimit().isPresent()) {
            group.setHardCpuLimit(match.getHardCpuLimit().get());
        }
    }

    public List<ResourceGroupSelector> getSelectors() {
        return this.selectors;
    }
}

