/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.presto.redis.RedisDataType;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class RedisSplit
implements ConnectorSplit {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final String keyDataFormat;
    private final String keyName;
    private final String valueDataFormat;
    private final RedisDataType valueDataType;
    private final RedisDataType keyDataType;
    private final List<HostAddress> nodes;
    private final long start;
    private final long end;

    @JsonCreator
    public RedisSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="valueDataFormat") String valueDataFormat, @JsonProperty(value="keyName") String keyName, @JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="nodes") List<HostAddress> nodes) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "dataFormat is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "KeydataFormat is null");
        this.valueDataFormat = Objects.requireNonNull(valueDataFormat, "valueDataFormat is null");
        this.keyName = keyName;
        this.nodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(nodes, "addresses is null"));
        this.start = start;
        this.end = end;
        this.valueDataType = RedisSplit.toRedisDataType(valueDataFormat);
        this.keyDataType = RedisSplit.toRedisDataType(keyDataFormat);
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getValueDataFormat() {
        return this.valueDataFormat;
    }

    @JsonProperty
    public String getKeyName() {
        return this.keyName;
    }

    @JsonProperty
    public List<HostAddress> getNodes() {
        return this.nodes;
    }

    public RedisDataType getValueDataType() {
        return this.valueDataType;
    }

    public RedisDataType getKeyDataType() {
        return this.keyDataType;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getEnd() {
        return this.end;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return this.nodes;
    }

    public Object getInfo() {
        return this;
    }

    private static RedisDataType toRedisDataType(String dataFormat) {
        switch (dataFormat) {
            case "hash": {
                return RedisDataType.HASH;
            }
            case "zset": {
                return RedisDataType.ZSET;
            }
        }
        return RedisDataType.STRING;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("keyDataFormat", (Object)this.keyDataFormat).add("valueDataFormat", (Object)this.valueDataFormat).add("keyName", (Object)this.keyName).add("start", this.start).add("end", this.end).add("nodes", this.nodes).toString();
    }
}

