/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.redis;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.FieldValueProviders;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.redis.RedisColumnHandle;
import com.facebook.presto.redis.RedisDataType;
import com.facebook.presto.redis.RedisInternalFieldDescription;
import com.facebook.presto.redis.RedisJedisManager;
import com.facebook.presto.redis.RedisSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisRecordCursor
implements RecordCursor {
    private static final Logger log = Logger.get(RedisRecordCursor.class);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final RowDecoder keyDecoder;
    private final RowDecoder valueDecoder;
    private final RedisSplit split;
    private final List<RedisColumnHandle> columnHandles;
    private final RedisJedisManager redisJedisManager;
    private final JedisPool jedisPool;
    private final ScanParams scanParams;
    private ScanResult<String> redisCursor;
    private Iterator<String> keysIterator;
    private final AtomicBoolean reported = new AtomicBoolean();
    private FieldValueProvider[] fieldValueProviders;
    private String valueString;
    private Map<String, String> valueMap;
    private long totalBytes;
    private long totalValues;
    private final FieldValueProvider[] currentRowValues;

    RedisRecordCursor(RowDecoder keyDecoder, RowDecoder valueDecoder, RedisSplit split, List<RedisColumnHandle> columnHandles, RedisJedisManager redisJedisManager) {
        this.keyDecoder = keyDecoder;
        this.valueDecoder = valueDecoder;
        this.split = split;
        this.columnHandles = columnHandles;
        this.redisJedisManager = redisJedisManager;
        this.jedisPool = redisJedisManager.getJedisPool(split.getNodes().get(0));
        this.scanParams = this.setScanParams();
        this.currentRowValues = new FieldValueProvider[columnHandles.size()];
        this.fetchKeys();
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.columnHandles.get(field).getType();
    }

    public boolean hasUnscannedData() {
        if (this.redisCursor == null) {
            return false;
        }
        return !this.redisCursor.getStringCursor().equals("0");
    }

    public boolean advanceNextPosition() {
        while (!this.keysIterator.hasNext()) {
            if (!this.hasUnscannedData()) {
                return this.endOfData();
            }
            this.fetchKeys();
        }
        return this.nextRow(this.keysIterator.next());
    }

    private boolean endOfData() {
        if (!this.reported.getAndSet(true)) {
            log.debug("Read a total of %d values with %d bytes.", new Object[]{this.totalValues, this.totalBytes});
        }
        return false;
    }

    private boolean nextRow(String keyString) {
        this.fetchData(keyString);
        byte[] keyData = keyString.getBytes(StandardCharsets.UTF_8);
        byte[] valueData = EMPTY_BYTE_ARRAY;
        if (this.valueString != null) {
            valueData = this.valueString.getBytes(StandardCharsets.UTF_8);
        }
        this.totalBytes += (long)valueData.length;
        ++this.totalValues;
        Optional decodedKey = this.keyDecoder.decodeRow(keyData, null);
        Optional decodedValue = this.valueDecoder.decodeRow(valueData, this.valueMap);
        HashMap<DecoderColumnHandle, FieldValueProvider> currentRowValuesMap = new HashMap<DecoderColumnHandle, FieldValueProvider>();
        block8: for (DecoderColumnHandle decoderColumnHandle : this.columnHandles) {
            if (!decoderColumnHandle.isInternal()) continue;
            RedisInternalFieldDescription fieldDescription = RedisInternalFieldDescription.forColumnName(decoderColumnHandle.getName());
            switch (fieldDescription) {
                case KEY_FIELD: {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])keyData));
                    continue block8;
                }
                case VALUE_FIELD: {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.bytesValueProvider((byte[])valueData));
                    continue block8;
                }
                case KEY_LENGTH_FIELD: {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)keyData.length));
                    continue block8;
                }
                case VALUE_LENGTH_FIELD: {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.longValueProvider((long)valueData.length));
                    continue block8;
                }
                case KEY_CORRUPT_FIELD: {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.booleanValueProvider((!decodedKey.isPresent() ? 1 : 0) != 0));
                    continue block8;
                }
                case VALUE_CORRUPT_FIELD: {
                    currentRowValuesMap.put(decoderColumnHandle, FieldValueProviders.booleanValueProvider((!decodedValue.isPresent() ? 1 : 0) != 0));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("unknown internal field " + (Object)((Object)fieldDescription));
        }
        decodedKey.ifPresent(currentRowValuesMap::putAll);
        decodedValue.ifPresent(currentRowValuesMap::putAll);
        for (int i = 0; i < this.columnHandles.size(); ++i) {
            ColumnHandle columnHandle = (ColumnHandle)this.columnHandles.get(i);
            this.currentRowValues[i] = (FieldValueProvider)currentRowValuesMap.get(columnHandle);
        }
        return true;
    }

    public boolean getBoolean(int field) {
        return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
    }

    public long getLong(int field) {
        return this.getFieldValueProvider(field, Long.TYPE).getLong();
    }

    public double getDouble(int field) {
        return this.getFieldValueProvider(field, Double.TYPE).getDouble();
    }

    public Slice getSlice(int field) {
        return this.getFieldValueProvider(field, Slice.class).getSlice();
    }

    public boolean isNull(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        return this.currentRowValues == null || this.currentRowValues[field].isNull();
    }

    public Object getObject(int field) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        throw new IllegalArgumentException(String.format("Type %s is not supported", this.getType(field)));
    }

    private FieldValueProvider getFieldValueProvider(int field, Class<?> expectedType) {
        Preconditions.checkArgument((field < this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
        this.checkFieldType(field, expectedType);
        return this.currentRowValues[field];
    }

    private void checkFieldType(int field, Class<?> expected) {
        Class actual = this.getType(field).getJavaType();
        Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
    }

    public void close() {
    }

    private ScanParams setScanParams() {
        if (this.split.getKeyDataType() == RedisDataType.STRING) {
            ScanParams scanParams = new ScanParams();
            scanParams.count(this.redisJedisManager.getRedisConnectorConfig().getRedisScanCount());
            if (this.redisJedisManager.getRedisConnectorConfig().isKeyPrefixSchemaTable()) {
                String keyMatch = "";
                if (!this.split.getSchemaName().equals("default")) {
                    keyMatch = this.split.getSchemaName() + this.redisJedisManager.getRedisConnectorConfig().getRedisKeyDelimiter();
                }
                keyMatch = keyMatch + this.split.getTableName() + this.redisJedisManager.getRedisConnectorConfig().getRedisKeyDelimiter() + "*";
                scanParams.match(keyMatch);
            }
            return scanParams;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fetchKeys() {
        try (Jedis jedis = this.jedisPool.getResource();){
            switch (this.split.getKeyDataType()) {
                case STRING: {
                    String cursor = ScanParams.SCAN_POINTER_START;
                    if (this.redisCursor != null) {
                        cursor = this.redisCursor.getStringCursor();
                    }
                    log.debug("Scanning new Redis keys from cursor %s . %d values read so far", new Object[]{cursor, this.totalValues});
                    this.redisCursor = jedis.scan(cursor, this.scanParams);
                    List keys = this.redisCursor.getResult();
                    this.keysIterator = keys.iterator();
                    return true;
                }
                case ZSET: {
                    Set keys = jedis.zrange(this.split.getKeyName(), this.split.getStart(), this.split.getEnd());
                    this.keysIterator = keys.iterator();
                    return true;
                }
                default: {
                    log.debug("Redis type of key %s is unsupported", new Object[]{this.split.getKeyDataFormat()});
                    boolean bl = false;
                    return bl;
                }
            }
        }
    }

    private boolean fetchData(String keyString) {
        this.valueString = null;
        this.valueMap = null;
        try (Jedis jedis = this.jedisPool.getResource();){
            switch (this.split.getValueDataType()) {
                case STRING: {
                    this.valueString = jedis.get(keyString);
                    if (this.valueString == null) {
                        log.warn("Redis data modified while query was running, string value at key %s deleted", new Object[]{keyString});
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                case HASH: {
                    this.valueMap = jedis.hgetAll(keyString);
                    if (this.valueMap == null) {
                        log.warn("Redis data modified while query was running, hash value at key %s deleted", new Object[]{keyString});
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
                default: {
                    log.debug("Redis type for key %s is unsupported", new Object[]{keyString});
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }
}

